/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.http.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.browsermob.proxy.jetty.http.BasicAuthenticator;
import org.browsermob.proxy.jetty.http.ClientCertAuthenticator;
import org.browsermob.proxy.jetty.http.HttpException;
import org.browsermob.proxy.jetty.http.HttpRequest;
import org.browsermob.proxy.jetty.http.HttpResponse;
import org.browsermob.proxy.jetty.http.handler.AbstractHttpHandler;
import org.browsermob.proxy.jetty.log.LogFactory;

public class SecurityHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(SecurityHandler.class);
    private String _authMethod = "BASIC";

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("Handler started");
        }
        this._authMethod = method;
    }

    @Override
    public void start() throws Exception {
        if (this.getHttpContext().getAuthenticator() == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new BasicAuthenticator());
            } else if ("CLIENT_CERT".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new ClientCertAuthenticator());
            } else {
                log.warn((Object)("Unknown Authentication method:" + this._authMethod));
            }
        }
        super.start();
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        this.getHttpContext().checkSecurityConstraints(pathInContext, request, response);
    }
}

