/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.browsermob.proxy.jetty.http.HttpConnection;
import org.browsermob.proxy.jetty.http.HttpFields;
import org.browsermob.proxy.jetty.http.HttpOutputStream;
import org.browsermob.proxy.jetty.log.LogFactory;
import org.browsermob.proxy.jetty.util.QuotedStringTokenizer;
import org.browsermob.proxy.jetty.util.TypeUtil;

public abstract class HttpMessage {
    private static Log log = LogFactory.getLog(HttpMessage.class);
    public static final String __SCHEME = "http";
    public static final String __SSL_SCHEME = "https";
    public static final String __HTTP_0_9 = "HTTP/0.9";
    public static final String __HTTP_1_0 = "HTTP/1.0";
    public static final String __HTTP_1_1 = "HTTP/1.1";
    public static final String __HTTP_1_X = "HTTP/1.";
    public static final int __MSG_EDITABLE = 0;
    public static final int __MSG_BAD = 1;
    public static final int __MSG_RECEIVED = 2;
    public static final int __MSG_SENDING = 3;
    public static final int __MSG_SENT = 4;
    public static final String[] __state = new String[]{"EDITABLE", "BAD", "RECEIVED", "SENDING", "SENT"};
    protected int _state = 0;
    protected String _version;
    protected int _dotVersion;
    protected HttpFields _header = new HttpFields();
    protected HttpConnection _connection;
    protected String _characterEncoding;
    protected String _mimeType;
    protected Object _wrapper;
    protected Map _attributes;

    protected HttpMessage() {
    }

    protected HttpMessage(HttpConnection connection) {
        this._connection = connection;
    }

    public void setWrapper(Object wrapper) {
        this._wrapper = wrapper;
    }

    public Object getWrapper() {
        return this._wrapper;
    }

    protected void reset() {
        this._state = 0;
        this._header.clear();
    }

    public HttpConnection getHttpConnection() {
        return this._connection;
    }

    public InputStream getInputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getOutputStream();
    }

    public int getState() {
        return this._state;
    }

    public int setState(int state) {
        int last = this._state;
        this._state = state;
        return last;
    }

    public String getVersion() {
        return this._version;
    }

    public int getDotVersion() {
        return this._dotVersion;
    }

    public Enumeration getFieldNames() {
        return this._header.getFieldNames();
    }

    public boolean containsField(String name) {
        return this._header.containsKey(name);
    }

    public String getField(String name) {
        return this._header.get(name);
    }

    public Enumeration getFieldValues(String name) {
        return this._header.getValues(name);
    }

    public Enumeration getFieldValues(String name, String separators) {
        return this._header.getValues(name, separators);
    }

    public String setField(String name, String value) {
        if (this._state != 0) {
            return null;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            String old = this._header.get(name);
            this.setContentType(value);
            return old;
        }
        return this._header.put(name, value);
    }

    public void setField(String name, List value) {
        if (this._state != 0) {
            return;
        }
        this._header.put(name, value);
    }

    public void addField(String name, String value) throws IllegalStateException {
        if (this._state != 0) {
            return;
        }
        this._header.add(name, value);
    }

    public int getIntField(String name) {
        return this._header.getIntField(name);
    }

    public void setIntField(String name, int value) {
        if (this._state != 0) {
            return;
        }
        this._header.put(name, TypeUtil.toString(value));
    }

    public void addIntField(String name, int value) {
        if (this._state != 0) {
            return;
        }
        this._header.add(name, TypeUtil.toString(value));
    }

    public long getDateField(String name) {
        return this._header.getDateField(name);
    }

    public void setDateField(String name, Date date) {
        if (this._state != 0) {
            return;
        }
        this._header.putDateField(name, date);
    }

    public void addDateField(String name, Date date) {
        if (this._state != 0) {
            return;
        }
        this._header.addDateField(name, date);
    }

    public void setDateField(String name, long date) {
        if (this._state != 0) {
            return;
        }
        this._header.putDateField(name, date);
    }

    public void addDateField(String name, long date) {
        if (this._state != 0) {
            return;
        }
        this._header.addDateField(name, date);
    }

    public String removeField(String name) throws IllegalStateException {
        if (this._state != 0) {
            return null;
        }
        return this._header.remove(name);
    }

    public void setVersion(String version) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        if (version.equalsIgnoreCase(__HTTP_1_1)) {
            this._dotVersion = 1;
            this._version = __HTTP_1_1;
        } else if (version.equalsIgnoreCase(__HTTP_1_0)) {
            this._dotVersion = 0;
            this._version = __HTTP_1_0;
        } else if (version.equalsIgnoreCase(__HTTP_0_9)) {
            this._dotVersion = -1;
            this._version = __HTTP_0_9;
        } else {
            throw new IllegalArgumentException("Unknown version");
        }
    }

    public HttpFields getHeader() {
        if (this._state != 0) {
            throw new IllegalStateException("Can't get header in " + __state[this._state]);
        }
        return this._header;
    }

    public int getContentLength() {
        return this.getIntField("Content-Length");
    }

    public void setContentLength(int len) {
        this.setIntField("Content-Length", len);
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String encoding, boolean setField) {
        if (this.isCommitted()) {
            return;
        }
        if (encoding == null) {
            if (this._characterEncoding != null) {
                this._characterEncoding = null;
                if (setField) {
                    this._header.put("Content-Type", this._mimeType);
                }
            }
        } else {
            this._characterEncoding = encoding;
            if (setField && this._mimeType != null) {
                this._header.put("Content-Type", this._mimeType + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= "));
            }
        }
    }

    public String getContentType() {
        return this.getField("Content-Type");
    }

    public void setContentType(String contentType) {
        if (this.isCommitted()) {
            return;
        }
        if (contentType == null) {
            this._mimeType = null;
            this._header.remove("Content-Type");
        } else {
            int i0 = contentType.indexOf(59);
            if (i0 > 0) {
                this._mimeType = contentType.substring(0, i0).trim();
                int i1 = contentType.indexOf("charset=", i0);
                if (i1 >= 0) {
                    int i2 = contentType.indexOf(32, i1 += 8);
                    this._characterEncoding = 0 < i2 ? contentType.substring(i1, i2) : contentType.substring(i1);
                    this._characterEncoding = QuotedStringTokenizer.unquote(this._characterEncoding);
                } else if (this._characterEncoding != null) {
                    contentType = contentType + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                }
            } else {
                this._mimeType = contentType;
                if (this._characterEncoding != null) {
                    contentType = contentType + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                }
            }
            this._header.put("Content-Type", contentType);
        }
    }

    public void updateMimeType() {
        this._mimeType = null;
        this._characterEncoding = null;
        String contentType = this._header.get("Content-Type");
        if (contentType != null) {
            int i0 = contentType.indexOf(59);
            if (i0 > 0) {
                this._mimeType = contentType.substring(0, i0).trim();
                int i1 = contentType.indexOf("charset=", i0);
                if (i1 >= 0) {
                    int i2 = contentType.indexOf(32, i1 += 8);
                    this._characterEncoding = 0 < i2 ? contentType.substring(i1, i2) : contentType.substring(i1);
                    this._characterEncoding = QuotedStringTokenizer.unquote(this._characterEncoding);
                }
            } else {
                this._mimeType = contentType;
            }
        }
    }

    public String getMimeType() {
        return this._mimeType;
    }

    void recycle(HttpConnection connection) {
        this._state = 0;
        this._version = __HTTP_1_1;
        this._dotVersion = 1;
        this._header.clear();
        this._connection = connection;
        this._characterEncoding = null;
        this._mimeType = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public void destroy() {
        this.recycle(null);
        if (this._header != null) {
            this._header.destroy();
        }
        this._header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        StringWriter writer = new StringWriter();
        int save_state = this._state;
        try {
            this._state = 0;
            this.writeHeader(writer);
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        finally {
            this._state = save_state;
        }
        return writer.toString();
    }

    abstract void writeHeader(Writer var1) throws IOException;

    public boolean isCommitted() {
        return this._state == 3 || this._state == 4;
    }

    public boolean isDirty() {
        HttpOutputStream out = (HttpOutputStream)this.getOutputStream();
        return this._state != 0 || out != null && out.isWritten();
    }

    public Object getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public Object setAttribute(String name, Object attribute) {
        if (this._attributes == null) {
            this._attributes = new HashMap(11);
        }
        return this._attributes.put(name, attribute);
    }

    public Enumeration getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._attributes.keySet());
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.remove(name);
        }
    }

    public static interface HeaderWriter {
        public void writeHeader(HttpMessage var1) throws IOException;
    }
}

