/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.TlsPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryOptions> {
    private static final SdkField<String> TLS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsPolicy").getter(DeliveryOptions.getter(DeliveryOptions::tlsPolicyAsString)).setter(DeliveryOptions.setter(Builder::tlsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeliveryOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tlsPolicy;

    private DeliveryOptions(BuilderImpl builder) {
        this.tlsPolicy = builder.tlsPolicy;
    }

    public final TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(this.tlsPolicy);
    }

    public final String tlsPolicyAsString() {
        return this.tlsPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryOptions)) {
            return false;
        }
        DeliveryOptions other = (DeliveryOptions)obj;
        return Objects.equals(this.tlsPolicyAsString(), other.tlsPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeliveryOptions").add("TlsPolicy", (Object)this.tlsPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TlsPolicy": {
                return Optional.ofNullable(clazz.cast(this.tlsPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TlsPolicy", TLS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeliveryOptions, T> g) {
        return obj -> g.apply((DeliveryOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tlsPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryOptions model) {
            this.tlsPolicy(model.tlsPolicy);
        }

        public final String getTlsPolicy() {
            return this.tlsPolicy;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy == null ? null : tlsPolicy.toString());
            return this;
        }

        public DeliveryOptions build() {
            return new DeliveryOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryOptions> {
        public Builder tlsPolicy(String var1);

        public Builder tlsPolicy(TlsPolicy var1);
    }
}

