/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.EmptyFileSet;
import de.flapdoodle.embed.process.store.IDownloader;
import de.flapdoodle.embed.process.store.IMutableArtifactStore;
import de.flapdoodle.embed.process.store.LocalArtifactStore;
import de.flapdoodle.embed.process.store.PostgresFilesToExtract;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresArtifactStore
implements IMutableArtifactStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresArtifactStore.class);
    private IDownloadConfig downloadConfig;
    private IDirectory tempDirFactory;
    private ITempNaming executableNaming;
    private IDownloader downloader;

    PostgresArtifactStore(IDownloadConfig downloadConfig, IDirectory tempDirFactory, ITempNaming executableNaming, IDownloader downloader) {
        this.downloadConfig = downloadConfig;
        this.tempDirFactory = tempDirFactory;
        this.executableNaming = executableNaming;
        this.downloader = downloader;
    }

    public IDirectory getTempDir() {
        return this.tempDirFactory;
    }

    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
        for (FileType type : EnumSet.complementOf(EnumSet.of(FileType.Executable))) {
            for (File file : all.files(type)) {
                if (!file.exists() || FileUtils.deleteQuietly((File)file)) continue;
                LOGGER.trace("Could not delete {} NOW: {}", (Object)type, (Object)file);
            }
        }
        File exe = all.executable();
        if (exe.exists() && !FileUtils.deleteQuietly((File)exe)) {
            LOGGER.trace("Could not delete executable NOW: {}", (Object)exe);
        }
        if (all.baseDirIsGenerated() && !FileUtils.deleteQuietly((File)all.baseDir())) {
            LOGGER.trace("Could not delete generatedBaseDir: {}", (Object)all.baseDir());
        }
    }

    public boolean checkDistribution(Distribution distribution) throws IOException {
        if (!LocalArtifactStore.checkArtifact((IDownloadConfig)this.downloadConfig, (Distribution)distribution)) {
            return LocalArtifactStore.store((IDownloadConfig)this.downloadConfig, (Distribution)distribution, (File)this.downloader.download(this.downloadConfig, distribution));
        }
        return true;
    }

    public IDownloadConfig getDownloadConfig() {
        return this.downloadConfig;
    }

    @Override
    public void setDownloadConfig(IDownloadConfig downloadConfig) {
        this.downloadConfig = downloadConfig;
    }

    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IPackageResolver packageResolver = this.downloadConfig.getPackageResolver();
        File artifact = this.getArtifact(this.downloadConfig, distribution);
        ArchiveType archiveType = packageResolver.getArchiveType(distribution);
        IExtractor extractor = Extractors.getExtractor((ArchiveType)archiveType);
        try {
            FileSet fileSet = packageResolver.getFileSet(distribution);
            return extractor.extract(this.downloadConfig, artifact, (FilesToExtract)new PostgresFilesToExtract(this.tempDirFactory, this.executableNaming, fileSet, distribution));
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract file set:", (Throwable)e);
            return new EmptyFileSet();
        }
    }

    private File getArtifact(IDownloadConfig runtime, Distribution distribution) {
        File dir = this.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, runtime.getPackageResolver().getPath(distribution));
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }

    private File createOrGetBaseDir(IDownloadConfig runtime) {
        File dir = runtime.getArtifactStorePath().asFile();
        this.createOrCheckDir(dir);
        return dir;
    }

    private void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }
}

