/* Resolvers.java

	Purpose:
		
	Description:
		
	History:
		Tue Dec 29 15:39:11 TST 2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

*/
package org.zkforge.apache.commons.el;

import org.zkoss.lang.Classes;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;

/**
 * Used to encapsulate the dependency of ZK 5.0.
 *
 * @author tomyeh
 * @since 1.1.0
 */
class Resolvers {
	private static final Resolver _resolver;
	static {
		Resolver resolver;
		try {
			Classes.forNameByThread("org.zkoss.xel.VariableResolverX");
			//ZK 5.x
			resolver = new Resolver() {
				public Object resolve(XelContext ctx, Object base, Object name) {
					Object o = ctx.getVariableResolver();
					return (o instanceof VariableResolverX) ?
							((VariableResolverX)o).resolveVariable(ctx, base, name):
						o != null && base == null && name != null ?
							((VariableResolver)o).resolveVariable(name.toString()):
						null;
				}
			};
		} catch (Throwable ex) {
			//ZK 3.x
			resolver = new Resolver() {
				public Object resolve(XelContext ctx, Object base, Object name) {
					return null;
				}
			};
		}
		_resolver = resolver;
	}
	private static interface Resolver {
		public Object resolve(XelContext ctx, Object base, Object name);
	}

	static Object resolve(XelContext ctx, Object base, Object name) {
		return _resolver.resolve(ctx, base, name);
	}
}
