/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.attr.AbstractStandardSingleAttributeModifierAttrProcessor;

public final class SpringMethodAttrProcessor
extends AbstractStandardSingleAttributeModifierAttrProcessor {
    public static final int ATTR_PRECEDENCE = 990;
    public static final String ATTR_NAME = "method";

    public SpringMethodAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 990;
    }

    protected String getTargetAttributeName(Arguments arguments, Element element, String attributeName) {
        return ATTR_NAME;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected void doAdditionalProcess(Arguments arguments, Element element, String attributeName) {
        String method;
        if ("form".equals(element.getNormalizedName()) && !this.isMethodBrowserSupported(method = element.getAttributeValue(ATTR_NAME))) {
            String type = "hidden";
            String name = "_method";
            String value = RequestDataValueProcessorUtils.processFormFieldValue(arguments.getConfiguration(), (IProcessingContext)arguments, "_method", method, "hidden");
            Element hiddenMethodElement = new Element("input");
            hiddenMethodElement.setAttribute("type", "hidden");
            hiddenMethodElement.setAttribute("name", "_method");
            hiddenMethodElement.setAttribute("value", value);
            element.insertChild(0, (Node)hiddenMethodElement);
            element.setAttribute(ATTR_NAME, "post");
        }
    }

    protected boolean isMethodBrowserSupported(String method) {
        return "get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method);
    }
}

