/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.jooq;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Target;
import org.testcontainers.jooq.codegen.jooq.JooqProps;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;

public class JooqGenerator {
    @Inject
    private MavenProject project;

    public void generateSources(RunnerProperties properties, JooqProps jooq) throws Exception {
        Log log = properties.log();
        this.checkGeneratorArguments(jooq, log);
        this.setGeneratorTargets(jooq);
        Jdbc jdbc = jooq.getJdbc();
        String basedir = Optional.ofNullable(jooq.getBaseDir()).orElse(this.project.getBasedir().getAbsolutePath());
        if (jdbc == null) {
            jdbc = new Jdbc();
        }
        jdbc.setUrl(properties.getUrl());
        jdbc.setUser(properties.getUsername());
        jdbc.setPassword(properties.getPassword());
        Configuration configuration = new Configuration();
        configuration.setJdbc(jdbc);
        configuration.setGenerator(jooq.getGenerator());
        configuration.setBasedir(basedir);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Using this configuration:\n" + configuration));
        }
        GenerationTool.generate((Configuration)configuration);
        this.project.addCompileSourceRoot(jooq.getGenerator().getTarget().getDirectory());
    }

    private void setGeneratorTargets(JooqProps jooq) {
        Generator generator = jooq.getGenerator();
        if (generator.getTarget() == null) {
            generator.setTarget(new Target());
        }
        if (generator.getTarget().getDirectory() == null) {
            generator.getTarget().setDirectory("target/generated-sources/jooq");
        }
    }

    private void checkGeneratorArguments(JooqProps jooq, Log log) throws MojoExecutionException {
        if (jooq.getGenerator() != null) {
            return;
        }
        log.error((CharSequence)"Incorrect configuration of jOOQ code generation tool");
        log.error((CharSequence)"The jOOQ-codegen-maven module's generator configuration is not set up correctly.\nThis can have a variety of reasons, among which:\n- Your pom.xml's <configuration> contains invalid XML according to %s\n- There is a version or artifact mismatch between your pom.xml and your commandline".formatted("jooq-codegen-3.18.0.xsd"));
        throw new MojoExecutionException("Incorrect configuration of jOOQ code generation tool. See error above for details.");
    }
}

