/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.CacheProviderFacade;
import org.springmodules.cache.provider.ObjectCannotBeCachedException;
import org.springmodules.cache.serializable.SerializableFactory;

public abstract class AbstractCacheProviderFacade
implements CacheProviderFacade {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean failQuietlyEnabled;
    private SerializableFactory serializableFactory;

    public final void afterPropertiesSet() throws FatalCacheException {
        this.validateCacheManager();
        this.onAfterPropertiesSet();
    }

    public final void cancelCacheUpdate(Serializable key) throws CacheException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to cancel a cache update using the key <" + StringUtils.quoteIfString((Object)key) + ">"));
        }
        try {
            this.onCancelCacheUpdate(key);
        }
        catch (CacheException exception) {
            this.handleCatchedException(exception);
        }
    }

    public final void flushCache(FlushingModel model) throws CacheException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to flush the cache using model <" + model + ">"));
        }
        if (model != null) {
            try {
                this.onFlushCache(model);
                this.logger.debug((Object)"Cache has been flushed.");
            }
            catch (CacheException exception) {
                this.handleCatchedException(exception);
            }
        }
    }

    public final Object getFromCache(Serializable key, CachingModel model) throws CacheException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to retrieve a cache entry using key <" + StringUtils.quoteIfString((Object)key) + "> and cache model <" + model + ">"));
        }
        Object cachedObject = null;
        try {
            if (model != null) {
                cachedObject = this.onGetFromCache(key, model);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved cache element <" + StringUtils.quoteIfString((Object)cachedObject) + ">"));
            }
        }
        catch (CacheException exception) {
            this.handleCatchedException(exception);
        }
        return cachedObject;
    }

    public final boolean isFailQuietlyEnabled() {
        return this.failQuietlyEnabled;
    }

    public final void putInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to store the object <" + obj + "> in the cache using key <" + StringUtils.quoteIfString((Object)key) + "> and model <" + model + ">"));
        }
        try {
            Object newCacheElement = this.makeSerializableIfNecessary(obj);
            if (model != null) {
                this.onPutInCache(key, model, newCacheElement);
                this.logger.debug((Object)"Object was successfully stored in the cache");
            }
        }
        catch (CacheException exception) {
            this.handleCatchedException(exception);
        }
    }

    public final void removeFromCache(Serializable key, CachingModel model) throws CacheException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to remove an entry from the cache using key <" + StringUtils.quoteIfString((Object)key) + "> and model <" + model + ">"));
        }
        if (model != null) {
            try {
                this.onRemoveFromCache(key, model);
                this.logger.debug((Object)"Object removed from the cache");
            }
            catch (CacheException exception) {
                this.handleCatchedException(exception);
            }
        }
    }

    public final void setFailQuietlyEnabled(boolean newFailQuietlyEnabled) {
        this.failQuietlyEnabled = newFailQuietlyEnabled;
    }

    public final void setSerializableFactory(SerializableFactory newSerializableFactory) {
        this.serializableFactory = newSerializableFactory;
    }

    protected final void assertCacheManagerIsNotNull(Object cacheManager) throws FatalCacheException {
        if (cacheManager == null) {
            throw new FatalCacheException("The cache manager should not be null");
        }
    }

    protected final void handleCatchedException(CacheException exception) throws CacheException {
        this.logger.error((Object)exception.getMessage(), (Throwable)((Object)exception));
        if (!this.isFailQuietlyEnabled()) {
            throw exception;
        }
    }

    protected abstract boolean isSerializableCacheElementRequired();

    protected final Object makeSerializableIfNecessary(Object obj) {
        if (!this.isSerializableCacheElementRequired()) {
            return obj;
        }
        if (obj instanceof Serializable) {
            return obj;
        }
        if (this.serializableFactory != null) {
            return this.serializableFactory.makeSerializableIfNecessary(obj);
        }
        throw new ObjectCannotBeCachedException("The cache can only store implementations of java.io.Serializable");
    }

    protected void onAfterPropertiesSet() throws FatalCacheException {
    }

    protected void onCancelCacheUpdate(Serializable key) throws CacheException {
        this.logger.info((Object)"Cache provider does not support cancelation of updates");
    }

    protected abstract void onFlushCache(FlushingModel var1) throws CacheException;

    protected abstract Object onGetFromCache(Serializable var1, CachingModel var2) throws CacheException;

    protected abstract void onPutInCache(Serializable var1, CachingModel var2, Object var3) throws CacheException;

    protected abstract void onRemoveFromCache(Serializable var1, CachingModel var2) throws CacheException;

    protected abstract void validateCacheManager() throws FatalCacheException;
}

