/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.impl.ObjectCannotBeCopiedException;
import org.springmodules.util.Objects;

public class Element
implements Serializable,
Cloneable {
    private static final long DEFAULT_TIME_TO_LIVE_MS = 120000L;
    private static final long EXPIRY_NEVER = -1L;
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$impl$Element == null ? (class$org$springmodules$cache$impl$Element = Element.class$("org.springmodules.cache.impl.Element")) : class$org$springmodules$cache$impl$Element));
    private static final long serialVersionUID = -935757449385127201L;
    private final long creationTime;
    private final Serializable key;
    private final long timeToLive;
    private Serializable value;
    static /* synthetic */ Class class$org$springmodules$cache$impl$Element;

    public Element(Serializable newKey, Serializable newValue) throws ObjectCannotBeCopiedException {
        this(newKey, newValue, -1L);
    }

    public Element(Serializable newKey, Serializable newValue, long newTimeToLive) throws ObjectCannotBeCopiedException {
        this(newKey, newValue, System.currentTimeMillis(), newTimeToLive);
    }

    private Element(Serializable newKey, Serializable newValue, long newCreationTime, long newTimeToLive) throws ObjectCannotBeCopiedException {
        this.key = this.copy(newKey);
        this.setValue(newValue);
        this.creationTime = newCreationTime;
        boolean invalidTimeToLive = newTimeToLive <= 0L && newTimeToLive != -1L;
        this.timeToLive = invalidTimeToLive ? 120000L : newTimeToLive;
    }

    public Object clone() {
        Element newElement = new Element(this.key, this.value, this.creationTime, this.timeToLive);
        return newElement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.key, (Object)other.key)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)other.value);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final Serializable getKey() {
        return this.key;
    }

    public final long getTimeToLive() {
        return this.timeToLive;
    }

    public final Serializable getValue() {
        return this.value;
    }

    public int hashCode() {
        int multiplier = 31;
        int hash = 7;
        hash = multiplier * hash + this.key.hashCode();
        hash = multiplier * hash + Objects.nullSafeHashCode(this.value);
        return hash;
    }

    public final boolean isAlive() {
        if (this.timeToLive == -1L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.creationTime;
        return delta < this.timeToLive;
    }

    public final boolean isExpired() {
        return !this.isAlive();
    }

    public final void setValue(Serializable newValue) throws ObjectCannotBeCopiedException {
        this.value = this.copy(newValue);
    }

    public String toString() {
        return Objects.identityToString(this).append("[key=").append(StringUtils.quoteIfString((Object)this.key)).append(", ").append("value=").append(StringUtils.quoteIfString((Object)this.value)).append(", ").append("creationTime=").append(new Date(this.creationTime)).append(", ").append("timeToLive=").append(this.timeToLive).append("]").toString();
    }

    private void close(InputStream closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            String clazz = closeable.getClass().getName();
            logger.error((Object)("Unable to close " + clazz), (Throwable)exception);
        }
    }

    private void close(OutputStream closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            String clazz = closeable.getClass().getName();
            logger.error((Object)("Unable to close " + clazz), (Throwable)exception);
        }
    }

    private Serializable copy(Serializable oldValue) throws ObjectCannotBeCopiedException {
        Serializable newValue = null;
        ByteArrayInputStream oldValueInputStream = null;
        ByteArrayOutputStream oldValueOutputStream = new ByteArrayOutputStream();
        ObjectInputStream newValueInputStream = null;
        ObjectOutputStream newValueOutputStream = null;
        try {
            newValueOutputStream = new ObjectOutputStream(oldValueOutputStream);
            newValueOutputStream.writeObject(oldValue);
            byte[] oldValueAsByteArray = oldValueOutputStream.toByteArray();
            oldValueInputStream = new ByteArrayInputStream(oldValueAsByteArray);
            newValueInputStream = new ObjectInputStream(oldValueInputStream);
            newValue = (Serializable)newValueInputStream.readObject();
            this.close(newValueInputStream);
            this.close(newValueOutputStream);
            this.close(oldValueInputStream);
            this.close(oldValueOutputStream);
        }
        catch (Exception exception) {
            try {
                String errMsg = "Unable to copy value " + oldValue;
                throw new ObjectCannotBeCopiedException(errMsg, exception);
            }
            catch (Throwable throwable) {
                this.close(newValueInputStream);
                this.close(newValueOutputStream);
                this.close(oldValueInputStream);
                this.close(oldValueOutputStream);
                throw throwable;
            }
        }
        return newValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

