/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WebSocketMessage {
    private final Type type;
    private final DataBuffer payload;

    public WebSocketMessage(Type type, DataBuffer payload) {
        Assert.notNull((Object)((Object)type), (String)"'type' must not be null");
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        this.type = type;
        this.payload = payload;
    }

    public Type getType() {
        return this.type;
    }

    public DataBuffer getPayload() {
        return this.payload;
    }

    public String getPayloadAsText() {
        byte[] bytes = new byte[this.payload.readableByteCount()];
        this.payload.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public WebSocketMessage retain() {
        DataBufferUtils.retain((DataBuffer)this.payload);
        return this;
    }

    public void release() {
        DataBufferUtils.release((DataBuffer)this.payload);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebSocketMessage)) {
            return false;
        }
        WebSocketMessage otherMessage = (WebSocketMessage)other;
        return this.type.equals((Object)otherMessage.type) && ObjectUtils.nullSafeEquals((Object)this.payload, (Object)otherMessage.payload);
    }

    public int hashCode() {
        return this.type.hashCode() * 29 + this.payload.hashCode();
    }

    public static enum Type {
        TEXT,
        BINARY,
        PING,
        PONG;

    }
}

