/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeHex(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        if (input == null) {
            return null;
        }
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }
}

