/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.AbstractMockServerSpec;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.DelegatingWebFluxConfiguration;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

class DefaultControllerSpec
extends AbstractMockServerSpec<WebTestClient.ControllerSpec>
implements WebTestClient.ControllerSpec {
    private final List<Object> controllers;
    private final List<Object> controllerAdvice = new ArrayList<Object>(8);
    private final TestWebFluxConfigurer configurer = new TestWebFluxConfigurer();

    DefaultControllerSpec(Object ... controllers) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])controllers) ? 1 : 0) != 0, (String)"At least one controller is required");
        this.controllers = Arrays.asList(controllers);
    }

    @Override
    public DefaultControllerSpec controllerAdvice(Object ... controllerAdvice) {
        this.controllerAdvice.addAll(Arrays.asList(controllerAdvice));
        return this;
    }

    @Override
    public DefaultControllerSpec contentTypeResolver(Consumer<RequestedContentTypeResolverBuilder> consumer) {
        this.configurer.contentTypeResolverConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec corsMappings(Consumer<CorsRegistry> consumer) {
        this.configurer.corsRegistryConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec argumentResolvers(Consumer<ArgumentResolverConfigurer> consumer) {
        this.configurer.argumentResolverConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec pathMatching(Consumer<PathMatchConfigurer> consumer) {
        this.configurer.pathMatchConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec httpMessageCodecs(Consumer<ServerCodecConfigurer> consumer) {
        this.configurer.messageCodecsConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec formatters(Consumer<FormatterRegistry> consumer) {
        this.configurer.formattersConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec validator(Validator validator) {
        this.configurer.validator = validator;
        return this;
    }

    @Override
    public DefaultControllerSpec viewResolvers(Consumer<ViewResolverRegistry> consumer) {
        this.configurer.viewResolversConsumer = consumer;
        return this;
    }

    @Override
    protected WebHttpHandlerBuilder initHttpHandlerBuilder() {
        return WebHttpHandlerBuilder.applicationContext((ApplicationContext)this.initApplicationContext());
    }

    private ApplicationContext initApplicationContext() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        this.controllers.forEach(controller -> {
            String name = controller.getClass().getName();
            context.registerBean(name, Object.class, () -> controller, new BeanDefinitionCustomizer[0]);
        });
        this.controllerAdvice.forEach(advice -> {
            String name = advice.getClass().getName();
            context.registerBean(name, Object.class, () -> advice, new BeanDefinitionCustomizer[0]);
        });
        context.register(new Class[]{DelegatingWebFluxConfiguration.class});
        context.registerBean(WebFluxConfigurer.class, () -> this.configurer, new BeanDefinitionCustomizer[0]);
        context.refresh();
        return context;
    }

    private class TestWebFluxConfigurer
    implements WebFluxConfigurer {
        @Nullable
        private Consumer<RequestedContentTypeResolverBuilder> contentTypeResolverConsumer;
        @Nullable
        private Consumer<CorsRegistry> corsRegistryConsumer;
        @Nullable
        private Consumer<ArgumentResolverConfigurer> argumentResolverConsumer;
        @Nullable
        private Consumer<PathMatchConfigurer> pathMatchConsumer;
        @Nullable
        private Consumer<ServerCodecConfigurer> messageCodecsConsumer;
        @Nullable
        private Consumer<FormatterRegistry> formattersConsumer;
        @Nullable
        private Validator validator;
        @Nullable
        private Consumer<ViewResolverRegistry> viewResolversConsumer;

        private TestWebFluxConfigurer() {
        }

        public void configureContentTypeResolver(RequestedContentTypeResolverBuilder builder) {
            if (this.contentTypeResolverConsumer != null) {
                this.contentTypeResolverConsumer.accept(builder);
            }
        }

        public void addCorsMappings(CorsRegistry registry) {
            if (this.corsRegistryConsumer != null) {
                this.corsRegistryConsumer.accept(registry);
            }
        }

        public void configurePathMatching(PathMatchConfigurer configurer) {
            if (this.pathMatchConsumer != null) {
                this.pathMatchConsumer.accept(configurer);
            }
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            if (this.argumentResolverConsumer != null) {
                this.argumentResolverConsumer.accept(configurer);
            }
        }

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            if (this.messageCodecsConsumer != null) {
                this.messageCodecsConsumer.accept(configurer);
            }
        }

        public void addFormatters(FormatterRegistry registry) {
            if (this.formattersConsumer != null) {
                this.formattersConsumer.accept(registry);
            }
        }

        @Nullable
        public Validator getValidator() {
            return this.validator;
        }

        public void configureViewResolvers(ViewResolverRegistry registry) {
            if (this.viewResolversConsumer != null) {
                this.viewResolversConsumer.accept(registry);
            }
        }
    }
}

