/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class PrintingResultHandler
implements ResultHandler {
    private final ResultValuePrinter printer;

    protected PrintingResultHandler(ResultValuePrinter printer) {
        this.printer = printer;
    }

    protected ResultValuePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public final void handle(MvcResult result) throws Exception {
        this.printer.printHeading("MockHttpServletRequest");
        this.printRequest(result.getRequest());
        this.printer.printHeading("Handler");
        this.printHandler(result.getHandler(), result.getInterceptors());
        this.printer.printHeading("Async");
        this.printAsyncResult(result);
        this.printer.printHeading("Resolved Exception");
        this.printResolvedException(result.getResolvedException());
        this.printer.printHeading("ModelAndView");
        this.printModelAndView(result.getModelAndView());
        this.printer.printHeading("FlashMap");
        this.printFlashMap(RequestContextUtils.getOutputFlashMap((HttpServletRequest)result.getRequest()));
        this.printer.printHeading("MockHttpServletResponse");
        this.printResponse(result.getResponse());
    }

    protected void printRequest(MockHttpServletRequest request) throws Exception {
        this.printer.printValue("HTTP Method", request.getMethod());
        this.printer.printValue("Request URI", request.getRequestURI());
        this.printer.printValue("Parameters", this.getParamsMultiValueMap(request));
        this.printer.printValue("Headers", this.getRequestHeaders(request));
    }

    protected final HttpHeaders getRequestHeaders(MockHttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name, values.nextElement());
            }
        }
        return headers;
    }

    protected final MultiValueMap<String, String> getParamsMultiValueMap(MockHttpServletRequest request) {
        Map<String, String[]> params = request.getParameterMap();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (String name : params.keySet()) {
            if (params.get(name) == null) continue;
            for (String value : params.get(name)) {
                multiValueMap.add((Object)name, (Object)value);
            }
        }
        return multiValueMap;
    }

    protected void printAsyncResult(MvcResult result) throws Exception {
        MockHttpServletRequest request = result.getRequest();
        this.printer.printValue("Async started", request.isAsyncStarted());
        Object asyncResult = null;
        try {
            asyncResult = result.getAsyncResult(0L);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.printer.printValue("Async result", asyncResult);
    }

    protected void printHandler(Object handler, HandlerInterceptor[] interceptors) throws Exception {
        if (handler == null) {
            this.printer.printValue("Type", null);
        } else if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            this.printer.printValue("Type", handlerMethod.getBeanType().getName());
            this.printer.printValue("Method", handlerMethod);
        } else {
            this.printer.printValue("Type", handler.getClass().getName());
        }
    }

    protected void printResolvedException(Exception resolvedException) throws Exception {
        if (resolvedException == null) {
            this.printer.printValue("Type", null);
        } else {
            this.printer.printValue("Type", resolvedException.getClass().getName());
        }
    }

    protected void printModelAndView(ModelAndView mav) throws Exception {
        this.printer.printValue("View name", mav != null ? mav.getViewName() : null);
        this.printer.printValue("View", mav != null ? mav.getView() : null);
        if (mav == null || mav.getModel().size() == 0) {
            this.printer.printValue("Model", null);
        } else {
            for (String name : mav.getModel().keySet()) {
                if (name.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                Object value = mav.getModel().get(name);
                this.printer.printValue("Attribute", name);
                this.printer.printValue("value", value);
                Errors errors = (Errors)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
                if (errors == null) continue;
                this.printer.printValue("errors", errors.getAllErrors());
            }
        }
    }

    protected void printFlashMap(FlashMap flashMap) throws Exception {
        if (flashMap == null) {
            this.printer.printValue("Attributes", null);
        } else {
            for (String name : flashMap.keySet()) {
                this.printer.printValue("Attribute", name);
                this.printer.printValue("value", flashMap.get((Object)name));
            }
        }
    }

    protected void printResponse(MockHttpServletResponse response) throws Exception {
        this.printer.printValue("Status", response.getStatus());
        this.printer.printValue("Error message", response.getErrorMessage());
        this.printer.printValue("Headers", this.getResponseHeaders(response));
        this.printer.printValue("Content type", response.getContentType());
        this.printer.printValue("Body", response.getContentAsString());
        this.printer.printValue("Forwarded URL", response.getForwardedUrl());
        this.printer.printValue("Redirected URL", response.getRedirectedUrl());
        this.printer.printValue("Cookies", response.getCookies());
    }

    protected final HttpHeaders getResponseHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : response.getHeaderNames()) {
            headers.put(name, (List)response.getHeaders(name));
        }
        return headers;
    }

    protected static interface ResultValuePrinter {
        public void printHeading(String var1);

        public void printValue(String var1, Object var2);
    }
}

