/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.testng;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@TestExecutionListeners(value={TransactionalTestExecutionListener.class})
@Transactional
public abstract class AbstractTransactionalTestNGSpringContextTests
extends AbstractTestNGSpringContextTests {
    protected JdbcTemplate jdbcTemplate;
    private String sqlScriptEncoding;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected int countRowsInTable(String tableName) {
        return JdbcTestUtils.countRowsInTable(this.jdbcTemplate, tableName);
    }

    protected int countRowsInTableWhere(String tableName, String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere(this.jdbcTemplate, tableName, whereClause);
    }

    protected int deleteFromTables(String ... names) {
        return JdbcTestUtils.deleteFromTables(this.jdbcTemplate, names);
    }

    protected int deleteFromTableWhere(String tableName, String whereClause, Object ... args) {
        return JdbcTestUtils.deleteFromTableWhere(this.jdbcTemplate, tableName, whereClause, args);
    }

    protected void dropTables(String ... names) {
        JdbcTestUtils.dropTables(this.jdbcTemplate, names);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = this.applicationContext.getResource(sqlResourcePath);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator(continueOnError, false, this.sqlScriptEncoding, new Resource[]{resource});
        DatabasePopulatorUtils.execute((DatabasePopulator)databasePopulator, (DataSource)this.jdbcTemplate.getDataSource());
    }
}

