/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.springframework.context.index.processor.StereotypesProvider;
import org.springframework.context.index.processor.TypeHelper;

class StandardStereotypesProvider
implements StereotypesProvider {
    private final TypeHelper typeHelper;

    StandardStereotypesProvider(TypeHelper typeHelper) {
        this.typeHelper = typeHelper;
    }

    @Override
    public Set<String> getStereotypes(Element element) {
        LinkedHashSet<String> stereotypes = new LinkedHashSet<String>();
        ElementKind kind = element.getKind();
        if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE) {
            return stereotypes;
        }
        for (AnnotationMirror annotationMirror : this.typeHelper.getAllAnnotationMirrors(element)) {
            String type = this.typeHelper.getType(annotationMirror);
            if (!type.startsWith("jakarta.")) continue;
            stereotypes.add(type);
        }
        return stereotypes;
    }
}

