/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import org.springframework.social.twitter.api.GeoOperations;
import org.springframework.social.twitter.api.Place;
import org.springframework.social.twitter.api.PlacePrototype;
import org.springframework.social.twitter.api.PlaceType;
import org.springframework.social.twitter.api.SimilarPlaces;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.PlacesList;
import org.springframework.social.twitter.api.impl.SimilarPlacesResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoTemplate
extends AbstractTwitterOperations
implements GeoOperations {
    private final RestTemplate restTemplate;

    public GeoTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public Place getPlace(String placeId) {
        this.requireAuthorization();
        return (Place)this.restTemplate.getForObject(this.buildUri("geo/id/" + placeId + ".json"), Place.class);
    }

    @Override
    public List<Place> reverseGeoCode(double latitude, double longitude) {
        return this.reverseGeoCode(latitude, longitude, null, null);
    }

    @Override
    public List<Place> reverseGeoCode(double latitude, double longitude, PlaceType granularity, String accuracy) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = this.buildGeoParameters(latitude, longitude, granularity, accuracy, null);
        return ((PlacesList)this.restTemplate.getForObject(this.buildUri("geo/reverse_geocode.json", parameters), PlacesList.class)).getList();
    }

    @Override
    public List<Place> search(double latitude, double longitude) {
        return this.search(latitude, longitude, null, null, null);
    }

    @Override
    public List<Place> search(double latitude, double longitude, PlaceType granularity, String accuracy, String query) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = this.buildGeoParameters(latitude, longitude, granularity, accuracy, query);
        return ((PlacesList)this.restTemplate.getForObject(this.buildUri("geo/search.json", parameters), PlacesList.class)).getList();
    }

    @Override
    public SimilarPlaces findSimilarPlaces(double latitude, double longitude, String name) {
        return this.findSimilarPlaces(latitude, longitude, name, null, null);
    }

    @Override
    public SimilarPlaces findSimilarPlaces(double latitude, double longitude, String name, String streetAddress, String containedWithin) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = this.buildPlaceParameters(latitude, longitude, name, streetAddress, containedWithin);
        SimilarPlacesResponse response = (SimilarPlacesResponse)this.restTemplate.getForObject(this.buildUri("geo/similar_places.json", parameters), SimilarPlacesResponse.class);
        PlacePrototype placePrototype = new PlacePrototype(response.getToken(), latitude, longitude, name, streetAddress, containedWithin);
        return new SimilarPlaces(response.getPlaces(), placePrototype);
    }

    @Override
    public Place createPlace(PlacePrototype placePrototype) {
        this.requireAuthorization();
        MultiValueMap<String, String> request = this.buildPlaceParameters(placePrototype.getLatitude(), placePrototype.getLongitude(), placePrototype.getName(), placePrototype.getStreetAddress(), placePrototype.getContainedWithin());
        request.set((Object)"token", (Object)placePrototype.getCreateToken());
        return (Place)this.restTemplate.postForObject("https://api.twitter.com/1.1/geo/place.json", request, Place.class, new Object[0]);
    }

    private MultiValueMap<String, String> buildGeoParameters(double latitude, double longitude, PlaceType granularity, String accuracy, String query) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"lat", (Object)String.valueOf(latitude));
        parameters.set((Object)"long", (Object)String.valueOf(longitude));
        if (granularity != null) {
            parameters.set((Object)"granularity", (Object)(granularity.equals((Object)PlaceType.POINT_OF_INTEREST) ? "poi" : granularity.toString().toLowerCase()));
        }
        if (accuracy != null) {
            parameters.set((Object)"accuracy", (Object)accuracy);
        }
        if (query != null) {
            parameters.set((Object)"query", (Object)query);
        }
        return parameters;
    }

    private MultiValueMap<String, String> buildPlaceParameters(double latitude, double longitude, String name, String streetAddress, String containedWithin) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"lat", (Object)String.valueOf(latitude));
        parameters.set((Object)"long", (Object)String.valueOf(longitude));
        parameters.set((Object)"name", (Object)name);
        if (streetAddress != null) {
            parameters.set((Object)"attribute:street_address", (Object)streetAddress);
        }
        if (containedWithin != null) {
            parameters.set((Object)"contained_within", (Object)containedWithin);
        }
        return parameters;
    }
}

