/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.DelegatingReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationCodeGrantWebFilter;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationRequestRedirectWebFilter;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationCodeAuthenticationTokenConverter;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.WebSessionOAuth2ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.authentication.OAuth2LoginAuthenticationWebFilter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderFactory;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;
import org.springframework.security.oauth2.server.resource.introspection.NimbusReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.access.server.BearerTokenServerAccessDeniedHandler;
import org.springframework.security.oauth2.server.resource.web.server.BearerTokenServerAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.server.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AnonymousAuthenticationWebFilter;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.HttpBasicServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.ReactivePreAuthenticatedAuthenticationManager;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerFormLoginAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerHttpBasicAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerX509AuthenticationConverter;
import org.springframework.security.web.server.authentication.logout.DelegatingServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.SecurityContextServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.AuthorizationWebFilter;
import org.springframework.security.web.server.authorization.DelegatingReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ExceptionTranslationWebFilter;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerWebExchangeDelegatingServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ReactorContextWebFilter;
import org.springframework.security.web.server.context.SecurityContextServerWebExchangeWebFilter;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.csrf.CsrfServerLogoutHandler;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.WebSessionServerCsrfTokenRepository;
import org.springframework.security.web.server.header.CacheControlServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CompositeServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentSecurityPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentTypeOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.FeaturePolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.HttpHeaderWriterWebFilter;
import org.springframework.security.web.server.header.ReferrerPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.security.web.server.header.StrictTransportSecurityServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XFrameOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XXssProtectionServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCacheWebFilter;
import org.springframework.security.web.server.savedrequest.WebSessionServerRequestCache;
import org.springframework.security.web.server.transport.HttpsRedirectWebFilter;
import org.springframework.security.web.server.ui.LoginPageGeneratingWebFilter;
import org.springframework.security.web.server.ui.LogoutPageGeneratingWebFilter;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ServerHttpSecurity {
    private ServerWebExchangeMatcher securityMatcher = ServerWebExchangeMatchers.anyExchange();
    private AuthorizeExchangeSpec authorizeExchange;
    private HttpsRedirectSpec httpsRedirectSpec;
    private HeaderSpec headers = new HeaderSpec();
    private CsrfSpec csrf = new CsrfSpec();
    private CorsSpec cors = new CorsSpec();
    private ExceptionHandlingSpec exceptionHandling = new ExceptionHandlingSpec();
    private HttpBasicSpec httpBasic;
    private X509Spec x509;
    private final RequestCacheSpec requestCache = new RequestCacheSpec();
    private FormLoginSpec formLogin;
    private OAuth2LoginSpec oauth2Login;
    private OAuth2ResourceServerSpec resourceServer;
    private OAuth2ClientSpec client;
    private LogoutSpec logout = new LogoutSpec();
    private LoginPageSpec loginPage = new LoginPageSpec();
    private ReactiveAuthenticationManager authenticationManager;
    private ServerSecurityContextRepository securityContextRepository;
    private ServerAuthenticationEntryPoint authenticationEntryPoint;
    private List<DelegatingServerAuthenticationEntryPoint.DelegateEntry> defaultEntryPoints = new ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry>();
    private ServerAccessDeniedHandler accessDeniedHandler;
    private List<ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry> defaultAccessDeniedHandlers = new ArrayList<ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry>();
    private List<WebFilter> webFilters = new ArrayList<WebFilter>();
    private ApplicationContext context;
    private Throwable built;
    private AnonymousSpec anonymous;

    public ServerHttpSecurity securityMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.securityMatcher = matcher;
        return this;
    }

    public ServerHttpSecurity addFilterAt(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder()));
        return this;
    }

    public ServerHttpSecurity addFilterBefore(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder() - 1));
        return this;
    }

    public ServerHttpSecurity addFilterAfter(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder() + 1));
        return this;
    }

    private ServerWebExchangeMatcher getSecurityMatcher() {
        return this.securityMatcher;
    }

    public ServerHttpSecurity securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
        return this;
    }

    public HttpsRedirectSpec redirectToHttps() {
        this.httpsRedirectSpec = new HttpsRedirectSpec();
        return this.httpsRedirectSpec;
    }

    public ServerHttpSecurity redirectToHttps(Customizer<HttpsRedirectSpec> httpsRedirectCustomizer) {
        this.httpsRedirectSpec = new HttpsRedirectSpec();
        httpsRedirectCustomizer.customize(this.httpsRedirectSpec);
        return this;
    }

    public CsrfSpec csrf() {
        if (this.csrf == null) {
            this.csrf = new CsrfSpec();
        }
        return this.csrf;
    }

    public ServerHttpSecurity csrf(Customizer<CsrfSpec> csrfCustomizer) {
        if (this.csrf == null) {
            this.csrf = new CsrfSpec();
        }
        csrfCustomizer.customize(this.csrf);
        return this;
    }

    public CorsSpec cors() {
        if (this.cors == null) {
            this.cors = new CorsSpec();
        }
        return this.cors;
    }

    public ServerHttpSecurity cors(Customizer<CorsSpec> corsCustomizer) {
        if (this.cors == null) {
            this.cors = new CorsSpec();
        }
        corsCustomizer.customize(this.cors);
        return this;
    }

    public AnonymousSpec anonymous() {
        if (this.anonymous == null) {
            this.anonymous = new AnonymousSpec();
        }
        return this.anonymous;
    }

    public ServerHttpSecurity anonymous(Customizer<AnonymousSpec> anonymousCustomizer) {
        if (this.anonymous == null) {
            this.anonymous = new AnonymousSpec();
        }
        anonymousCustomizer.customize(this.anonymous);
        return this;
    }

    public HttpBasicSpec httpBasic() {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicSpec();
        }
        return this.httpBasic;
    }

    public ServerHttpSecurity httpBasic(Customizer<HttpBasicSpec> httpBasicCustomizer) {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicSpec();
        }
        httpBasicCustomizer.customize(this.httpBasic);
        return this;
    }

    public FormLoginSpec formLogin() {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginSpec();
        }
        return this.formLogin;
    }

    public ServerHttpSecurity formLogin(Customizer<FormLoginSpec> formLoginCustomizer) {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginSpec();
        }
        formLoginCustomizer.customize(this.formLogin);
        return this;
    }

    public X509Spec x509() {
        if (this.x509 == null) {
            this.x509 = new X509Spec();
        }
        return this.x509;
    }

    public ServerHttpSecurity x509(Customizer<X509Spec> x509Customizer) {
        if (this.x509 == null) {
            this.x509 = new X509Spec();
        }
        x509Customizer.customize(this.x509);
        return this;
    }

    public OAuth2LoginSpec oauth2Login() {
        if (this.oauth2Login == null) {
            this.oauth2Login = new OAuth2LoginSpec();
        }
        return this.oauth2Login;
    }

    public ServerHttpSecurity oauth2Login(Customizer<OAuth2LoginSpec> oauth2LoginCustomizer) {
        if (this.oauth2Login == null) {
            this.oauth2Login = new OAuth2LoginSpec();
        }
        oauth2LoginCustomizer.customize(this.oauth2Login);
        return this;
    }

    public OAuth2ClientSpec oauth2Client() {
        if (this.client == null) {
            this.client = new OAuth2ClientSpec();
        }
        return this.client;
    }

    public ServerHttpSecurity oauth2Client(Customizer<OAuth2ClientSpec> oauth2ClientCustomizer) {
        if (this.client == null) {
            this.client = new OAuth2ClientSpec();
        }
        oauth2ClientCustomizer.customize(this.client);
        return this;
    }

    public OAuth2ResourceServerSpec oauth2ResourceServer() {
        if (this.resourceServer == null) {
            this.resourceServer = new OAuth2ResourceServerSpec();
        }
        return this.resourceServer;
    }

    public ServerHttpSecurity oauth2ResourceServer(Customizer<OAuth2ResourceServerSpec> oauth2ResourceServerCustomizer) {
        if (this.resourceServer == null) {
            this.resourceServer = new OAuth2ResourceServerSpec();
        }
        oauth2ResourceServerCustomizer.customize(this.resourceServer);
        return this;
    }

    public HeaderSpec headers() {
        if (this.headers == null) {
            this.headers = new HeaderSpec();
        }
        return this.headers;
    }

    public ServerHttpSecurity headers(Customizer<HeaderSpec> headerCustomizer) {
        if (this.headers == null) {
            this.headers = new HeaderSpec();
        }
        headerCustomizer.customize(this.headers);
        return this;
    }

    public ExceptionHandlingSpec exceptionHandling() {
        if (this.exceptionHandling == null) {
            this.exceptionHandling = new ExceptionHandlingSpec();
        }
        return this.exceptionHandling;
    }

    public ServerHttpSecurity exceptionHandling(Customizer<ExceptionHandlingSpec> exceptionHandlingCustomizer) {
        if (this.exceptionHandling == null) {
            this.exceptionHandling = new ExceptionHandlingSpec();
        }
        exceptionHandlingCustomizer.customize(this.exceptionHandling);
        return this;
    }

    public AuthorizeExchangeSpec authorizeExchange() {
        if (this.authorizeExchange == null) {
            this.authorizeExchange = new AuthorizeExchangeSpec();
        }
        return this.authorizeExchange;
    }

    public ServerHttpSecurity authorizeExchange(Customizer<AuthorizeExchangeSpec> authorizeExchangeCustomizer) {
        if (this.authorizeExchange == null) {
            this.authorizeExchange = new AuthorizeExchangeSpec();
        }
        authorizeExchangeCustomizer.customize(this.authorizeExchange);
        return this;
    }

    public LogoutSpec logout() {
        if (this.logout == null) {
            this.logout = new LogoutSpec();
        }
        return this.logout;
    }

    public ServerHttpSecurity logout(Customizer<LogoutSpec> logoutCustomizer) {
        if (this.logout == null) {
            this.logout = new LogoutSpec();
        }
        logoutCustomizer.customize(this.logout);
        return this;
    }

    public RequestCacheSpec requestCache() {
        return this.requestCache;
    }

    public ServerHttpSecurity requestCache(Customizer<RequestCacheSpec> requestCacheCustomizer) {
        requestCacheCustomizer.customize(this.requestCache);
        return this;
    }

    public ServerHttpSecurity authenticationManager(ReactiveAuthenticationManager manager) {
        this.authenticationManager = manager;
        return this;
    }

    public SecurityWebFilterChain build() {
        if (this.built != null) {
            throw new IllegalStateException("This has already been built with the following stacktrace. " + this.buildToString());
        }
        this.built = new RuntimeException("First Build Invocation").fillInStackTrace();
        if (this.headers != null) {
            this.headers.configure(this);
        }
        WebFilter securityContextRepositoryWebFilter = this.securityContextRepositoryWebFilter();
        this.webFilters.add(securityContextRepositoryWebFilter);
        if (this.httpsRedirectSpec != null) {
            this.httpsRedirectSpec.configure(this);
        }
        if (this.x509 != null) {
            this.x509.configure(this);
        }
        if (this.csrf != null) {
            this.csrf.configure(this);
        }
        if (this.cors != null) {
            this.cors.configure(this);
        }
        if (this.httpBasic != null) {
            if (this.httpBasic.authenticationManager == null) {
                this.httpBasic.authenticationManager(this.authenticationManager);
            }
            if (this.httpBasic.securityContextRepository != null) {
                this.httpBasic.securityContextRepository(this.httpBasic.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.httpBasic.securityContextRepository(this.securityContextRepository);
            } else {
                this.httpBasic.securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
            }
            this.httpBasic.configure(this);
        }
        if (this.formLogin != null) {
            if (this.formLogin.authenticationManager == null) {
                this.formLogin.authenticationManager(this.authenticationManager);
            }
            if (this.formLogin.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.formLogin.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.securityContextRepository);
            } else {
                this.formLogin.securityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
            }
            this.formLogin.configure(this);
        }
        if (this.oauth2Login != null) {
            if (this.oauth2Login.securityContextRepository != null) {
                this.oauth2Login.securityContextRepository(this.oauth2Login.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.oauth2Login.securityContextRepository(this.securityContextRepository);
            } else {
                this.oauth2Login.securityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
            }
            this.oauth2Login.configure(this);
        }
        if (this.resourceServer != null) {
            this.resourceServer.configure(this);
        }
        if (this.client != null) {
            this.client.configure(this);
        }
        if (this.anonymous != null) {
            this.anonymous.configure(this);
        }
        this.loginPage.configure(this);
        if (this.logout != null) {
            this.logout.configure(this);
        }
        this.requestCache.configure(this);
        this.addFilterAt((WebFilter)new SecurityContextServerWebExchangeWebFilter(), SecurityWebFiltersOrder.SECURITY_CONTEXT_SERVER_WEB_EXCHANGE);
        if (this.authorizeExchange != null) {
            ServerAccessDeniedHandler accessDeniedHandler;
            ServerAuthenticationEntryPoint authenticationEntryPoint = this.getAuthenticationEntryPoint();
            ExceptionTranslationWebFilter exceptionTranslationWebFilter = new ExceptionTranslationWebFilter();
            if (authenticationEntryPoint != null) {
                exceptionTranslationWebFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
            }
            if ((accessDeniedHandler = this.getAccessDeniedHandler()) != null) {
                exceptionTranslationWebFilter.setAccessDeniedHandler(accessDeniedHandler);
            }
            this.addFilterAt((WebFilter)exceptionTranslationWebFilter, SecurityWebFiltersOrder.EXCEPTION_TRANSLATION);
            this.authorizeExchange.configure(this);
        }
        AnnotationAwareOrderComparator.sort(this.webFilters);
        ArrayList<ServerWebExchangeReactorContextWebFilter> sortedWebFilters = new ArrayList<ServerWebExchangeReactorContextWebFilter>();
        this.webFilters.forEach(f -> {
            if (f instanceof OrderedWebFilter) {
                f = ((OrderedWebFilter)f).webFilter;
            }
            sortedWebFilters.add((ServerWebExchangeReactorContextWebFilter)f);
        });
        sortedWebFilters.add(0, new ServerWebExchangeReactorContextWebFilter());
        return new MatcherSecurityWebFilterChain(this.getSecurityMatcher(), sortedWebFilters);
    }

    /*
     * Exception decompiling
     */
    private String buildToString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ServerAuthenticationEntryPoint getAuthenticationEntryPoint() {
        if (this.authenticationEntryPoint != null || this.defaultEntryPoints.isEmpty()) {
            return this.authenticationEntryPoint;
        }
        if (this.defaultEntryPoints.size() == 1) {
            return this.defaultEntryPoints.get(0).getEntryPoint();
        }
        DelegatingServerAuthenticationEntryPoint result = new DelegatingServerAuthenticationEntryPoint(this.defaultEntryPoints);
        result.setDefaultEntryPoint(this.defaultEntryPoints.get(this.defaultEntryPoints.size() - 1).getEntryPoint());
        return result;
    }

    private ServerAccessDeniedHandler getAccessDeniedHandler() {
        if (this.accessDeniedHandler != null || this.defaultAccessDeniedHandlers.isEmpty()) {
            return this.accessDeniedHandler;
        }
        if (this.defaultAccessDeniedHandlers.size() == 1) {
            return this.defaultAccessDeniedHandlers.get(0).getAccessDeniedHandler();
        }
        ServerWebExchangeDelegatingServerAccessDeniedHandler result = new ServerWebExchangeDelegatingServerAccessDeniedHandler(this.defaultAccessDeniedHandlers);
        result.setDefaultAccessDeniedHandler(this.defaultAccessDeniedHandlers.get(this.defaultAccessDeniedHandlers.size() - 1).getAccessDeniedHandler());
        return result;
    }

    public static ServerHttpSecurity http() {
        return new ServerHttpSecurity();
    }

    private WebFilter securityContextRepositoryWebFilter() {
        WebSessionServerSecurityContextRepository repository = this.securityContextRepository == null ? new WebSessionServerSecurityContextRepository() : this.securityContextRepository;
        ReactorContextWebFilter result = new ReactorContextWebFilter((ServerSecurityContextRepository)repository);
        return new OrderedWebFilter((WebFilter)result, SecurityWebFiltersOrder.REACTOR_CONTEXT.getOrder());
    }

    protected ServerHttpSecurity() {
    }

    private <T> T getBean(Class<T> beanClass) {
        if (this.context == null) {
            return null;
        }
        return (T)this.context.getBean(beanClass);
    }

    private <T> T getBeanOrNull(Class<T> beanClass) {
        return this.getBeanOrNull(ResolvableType.forClass(beanClass));
    }

    private <T> T getBeanOrNull(ResolvableType type) {
        if (this.context == null) {
            return null;
        }
        String[] names = this.context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)this.context.getBean(names[0]);
        }
        return null;
    }

    protected void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public final class AnonymousSpec {
        private String key;
        private AnonymousAuthenticationWebFilter authenticationFilter;
        private Object principal = "anonymousUser";
        private List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"});

        public AnonymousSpec key(String key) {
            this.key = key;
            return this;
        }

        public AnonymousSpec principal(Object principal) {
            this.principal = principal;
            return this;
        }

        public AnonymousSpec authorities(List<GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public AnonymousSpec authorities(String ... authorities) {
            return this.authorities(AuthorityUtils.createAuthorityList((String[])authorities));
        }

        public AnonymousSpec authenticationFilter(AnonymousAuthenticationWebFilter authenticationFilter) {
            this.authenticationFilter = authenticationFilter;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.anonymous = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.authenticationFilter == null) {
                this.authenticationFilter = new AnonymousAuthenticationWebFilter(this.getKey(), this.principal, this.authorities);
            }
            http.addFilterAt((WebFilter)this.authenticationFilter, SecurityWebFiltersOrder.ANONYMOUS_AUTHENTICATION);
        }

        private String getKey() {
            if (this.key == null) {
                this.key = UUID.randomUUID().toString();
            }
            return this.key;
        }

        private AnonymousSpec() {
        }
    }

    static class ServerWebExchangeReactorContextWebFilter
    implements WebFilter {
        ServerWebExchangeReactorContextWebFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            return chain.filter(exchange).subscriberContext(Context.of(ServerWebExchange.class, (Object)exchange));
        }
    }

    private static class OrderedWebFilter
    implements WebFilter,
    Ordered {
        private final WebFilter webFilter;
        private final int order;

        OrderedWebFilter(WebFilter webFilter, int order) {
            this.webFilter = webFilter;
            this.order = order;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            return this.webFilter.filter(exchange, chain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedWebFilter{webFilter=" + this.webFilter + ", order=" + this.order + '}';
        }
    }

    public final class LogoutSpec {
        private LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
        private List<ServerLogoutHandler> logoutHandlers = new ArrayList<SecurityContextServerLogoutHandler>(Arrays.asList(new SecurityContextServerLogoutHandler()));

        public LogoutSpec logoutHandler(ServerLogoutHandler logoutHandler) {
            Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
            this.logoutHandlers.clear();
            return this.addLogoutHandler(logoutHandler);
        }

        private LogoutSpec addLogoutHandler(ServerLogoutHandler logoutHandler) {
            Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
            this.logoutHandlers.add(logoutHandler);
            return this;
        }

        public LogoutSpec logoutUrl(String logoutUrl) {
            Assert.notNull((Object)logoutUrl, (String)"logoutUrl must not be null");
            ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{logoutUrl});
            return this.requiresLogout(requiresLogout);
        }

        public LogoutSpec requiresLogout(ServerWebExchangeMatcher requiresLogout) {
            this.logoutWebFilter.setRequiresLogoutMatcher(requiresLogout);
            return this;
        }

        public LogoutSpec logoutSuccessHandler(ServerLogoutSuccessHandler handler) {
            this.logoutWebFilter.setLogoutSuccessHandler(handler);
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.logout = null;
            return this.and();
        }

        private ServerLogoutHandler createLogoutHandler() {
            if (this.logoutHandlers.isEmpty()) {
                return null;
            }
            if (this.logoutHandlers.size() == 1) {
                return this.logoutHandlers.get(0);
            }
            return new DelegatingServerLogoutHandler(this.logoutHandlers);
        }

        protected void configure(ServerHttpSecurity http) {
            ServerLogoutHandler logoutHandler = this.createLogoutHandler();
            if (logoutHandler != null) {
                this.logoutWebFilter.setLogoutHandler(logoutHandler);
            }
            http.addFilterAt((WebFilter)this.logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
        }

        private LogoutSpec() {
        }
    }

    public class HeaderSpec {
        private final List<ServerHttpHeadersWriter> writers;
        private CacheControlServerHttpHeadersWriter cacheControl = new CacheControlServerHttpHeadersWriter();
        private ContentTypeOptionsServerHttpHeadersWriter contentTypeOptions = new ContentTypeOptionsServerHttpHeadersWriter();
        private StrictTransportSecurityServerHttpHeadersWriter hsts = new StrictTransportSecurityServerHttpHeadersWriter();
        private XFrameOptionsServerHttpHeadersWriter frameOptions = new XFrameOptionsServerHttpHeadersWriter();
        private XXssProtectionServerHttpHeadersWriter xss = new XXssProtectionServerHttpHeadersWriter();
        private FeaturePolicyServerHttpHeadersWriter featurePolicy = new FeaturePolicyServerHttpHeadersWriter();
        private ContentSecurityPolicyServerHttpHeadersWriter contentSecurityPolicy = new ContentSecurityPolicyServerHttpHeadersWriter();
        private ReferrerPolicyServerHttpHeadersWriter referrerPolicy = new ReferrerPolicyServerHttpHeadersWriter();

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.headers = null;
            return ServerHttpSecurity.this;
        }

        public CacheSpec cache() {
            return new CacheSpec();
        }

        public HeaderSpec cache(Customizer<CacheSpec> cacheCustomizer) {
            cacheCustomizer.customize(new CacheSpec());
            return this;
        }

        public ContentTypeOptionsSpec contentTypeOptions() {
            return new ContentTypeOptionsSpec();
        }

        public HeaderSpec contentTypeOptions(Customizer<ContentTypeOptionsSpec> contentTypeOptionsCustomizer) {
            contentTypeOptionsCustomizer.customize(new ContentTypeOptionsSpec());
            return this;
        }

        public FrameOptionsSpec frameOptions() {
            return new FrameOptionsSpec();
        }

        public HeaderSpec frameOptions(Customizer<FrameOptionsSpec> frameOptionsCustomizer) {
            frameOptionsCustomizer.customize(new FrameOptionsSpec());
            return this;
        }

        public HstsSpec hsts() {
            return new HstsSpec();
        }

        public HeaderSpec hsts(Customizer<HstsSpec> hstsCustomizer) {
            hstsCustomizer.customize(new HstsSpec());
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            CompositeServerHttpHeadersWriter writer = new CompositeServerHttpHeadersWriter(this.writers);
            HttpHeaderWriterWebFilter result = new HttpHeaderWriterWebFilter((ServerHttpHeadersWriter)writer);
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
        }

        public XssProtectionSpec xssProtection() {
            return new XssProtectionSpec();
        }

        public HeaderSpec xssProtection(Customizer<XssProtectionSpec> xssProtectionCustomizer) {
            xssProtectionCustomizer.customize(new XssProtectionSpec());
            return this;
        }

        public ContentSecurityPolicySpec contentSecurityPolicy(String policyDirectives) {
            return new ContentSecurityPolicySpec(policyDirectives);
        }

        public HeaderSpec contentSecurityPolicy(Customizer<ContentSecurityPolicySpec> contentSecurityPolicyCustomizer) {
            contentSecurityPolicyCustomizer.customize(new ContentSecurityPolicySpec());
            return this;
        }

        public FeaturePolicySpec featurePolicy(String policyDirectives) {
            return new FeaturePolicySpec(policyDirectives);
        }

        public ReferrerPolicySpec referrerPolicy(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
            return new ReferrerPolicySpec(referrerPolicy);
        }

        public ReferrerPolicySpec referrerPolicy() {
            return new ReferrerPolicySpec();
        }

        public HeaderSpec referrerPolicy(Customizer<ReferrerPolicySpec> referrerPolicyCustomizer) {
            referrerPolicyCustomizer.customize(new ReferrerPolicySpec());
            return this;
        }

        private HeaderSpec() {
            this.writers = new ArrayList<ServerHttpHeadersWriter>(Arrays.asList(this.cacheControl, this.contentTypeOptions, this.hsts, this.frameOptions, this.xss, this.featurePolicy, this.contentSecurityPolicy, this.referrerPolicy));
        }

        public class ReferrerPolicySpec {
            public ReferrerPolicySpec policy(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
                HeaderSpec.this.referrerPolicy.setPolicy(referrerPolicy);
                return this;
            }

            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            private ReferrerPolicySpec() {
            }

            private ReferrerPolicySpec(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
                HeaderSpec.this.referrerPolicy.setPolicy(referrerPolicy);
            }
        }

        public class FeaturePolicySpec {
            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            private FeaturePolicySpec(String policyDirectives) {
                HeaderSpec.this.featurePolicy.setPolicyDirectives(policyDirectives);
            }
        }

        public class ContentSecurityPolicySpec {
            private static final String DEFAULT_SRC_SELF_POLICY = "default-src 'self'";

            public HeaderSpec reportOnly(boolean reportOnly) {
                HeaderSpec.this.contentSecurityPolicy.setReportOnly(reportOnly);
                return HeaderSpec.this;
            }

            public HeaderSpec policyDirectives(String policyDirectives) {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(policyDirectives);
                return HeaderSpec.this;
            }

            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            private ContentSecurityPolicySpec(String policyDirectives) {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(policyDirectives);
            }

            private ContentSecurityPolicySpec() {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(DEFAULT_SRC_SELF_POLICY);
            }
        }

        public class XssProtectionSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.xss);
                return HeaderSpec.this;
            }

            private XssProtectionSpec() {
            }
        }

        public class HstsSpec {
            public HstsSpec maxAge(Duration maxAge) {
                HeaderSpec.this.hsts.setMaxAge(maxAge);
                return this;
            }

            public HstsSpec includeSubdomains(boolean includeSubDomains) {
                HeaderSpec.this.hsts.setIncludeSubDomains(includeSubDomains);
                return this;
            }

            public HstsSpec preload(boolean preload) {
                HeaderSpec.this.hsts.setPreload(preload);
                return this;
            }

            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.hsts);
                return HeaderSpec.this;
            }

            private HstsSpec() {
            }
        }

        public class FrameOptionsSpec {
            public HeaderSpec mode(XFrameOptionsServerHttpHeadersWriter.Mode mode) {
                HeaderSpec.this.frameOptions.setMode(mode);
                return this.and();
            }

            private HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.frameOptions);
                return this.and();
            }

            private FrameOptionsSpec() {
            }
        }

        public class ContentTypeOptionsSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.contentTypeOptions);
                return HeaderSpec.this;
            }

            private ContentTypeOptionsSpec() {
            }
        }

        public class CacheSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.cacheControl);
                return HeaderSpec.this;
            }

            private CacheSpec() {
            }
        }
    }

    private class LoginPageSpec {
        protected void configure(ServerHttpSecurity http) {
            if (http.authenticationEntryPoint != null) {
                return;
            }
            if (http.formLogin != null && http.formLogin.isEntryPointExplicit) {
                return;
            }
            LoginPageGeneratingWebFilter loginPage = null;
            if (http.formLogin != null && !http.formLogin.isEntryPointExplicit) {
                loginPage = new LoginPageGeneratingWebFilter();
                loginPage.setFormLoginEnabled(true);
            }
            if (http.oauth2Login != null) {
                Map urlToText = http.oauth2Login.getLinks();
                if (loginPage == null) {
                    loginPage = new LoginPageGeneratingWebFilter();
                }
                loginPage.setOauth2AuthenticationUrlToClientName(urlToText);
            }
            if (loginPage != null) {
                http.addFilterAt((WebFilter)loginPage, SecurityWebFiltersOrder.LOGIN_PAGE_GENERATING);
                http.addFilterAt((WebFilter)new LogoutPageGeneratingWebFilter(), SecurityWebFiltersOrder.LOGOUT_PAGE_GENERATING);
            }
        }

        private LoginPageSpec() {
        }
    }

    public class FormLoginSpec {
        private final RedirectServerAuthenticationSuccessHandler defaultSuccessHandler = new RedirectServerAuthenticationSuccessHandler("/");
        private RedirectServerAuthenticationEntryPoint defaultEntryPoint;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationEntryPoint authenticationEntryPoint;
        private boolean isEntryPointExplicit;
        private ServerWebExchangeMatcher requiresAuthenticationMatcher;
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private ServerAuthenticationSuccessHandler authenticationSuccessHandler = this.defaultSuccessHandler;

        public FormLoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public FormLoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler = authenticationSuccessHandler;
            return this;
        }

        public FormLoginSpec loginPage(String loginPage) {
            this.defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(loginPage);
            this.authenticationEntryPoint = this.defaultEntryPoint;
            if (this.requiresAuthenticationMatcher == null) {
                this.requiresAuthenticationMatcher = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{loginPage});
            }
            if (this.authenticationFailureHandler == null) {
                this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler(loginPage + "?error");
            }
            return this;
        }

        public FormLoginSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public FormLoginSpec requiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
            this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
            return this;
        }

        public FormLoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        public FormLoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.formLogin = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.authenticationEntryPoint == null) {
                this.isEntryPointExplicit = false;
                this.loginPage("/login");
            } else {
                this.isEntryPointExplicit = true;
            }
            if (http.requestCache != null) {
                ServerRequestCache requestCache = http.requestCache.requestCache;
                this.defaultSuccessHandler.setRequestCache(requestCache);
                if (this.defaultEntryPoint != null) {
                    this.defaultEntryPoint.setRequestCache(requestCache);
                }
            }
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_HTML});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerHttpSecurity.this.defaultEntryPoints.add(0, new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)htmlMatcher, this.authenticationEntryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setRequiresAuthenticationMatcher(this.requiresAuthenticationMatcher);
            authenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
            authenticationFilter.setAuthenticationConverter((Function)new ServerFormLoginAuthenticationConverter());
            authenticationFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.FORM_LOGIN);
        }

        private FormLoginSpec() {
        }
    }

    public class HttpBasicSpec {
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationEntryPoint entryPoint = new HttpBasicServerAuthenticationEntryPoint();

        public HttpBasicSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public HttpBasicSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public HttpBasicSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            Assert.notNull((Object)authenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
            this.entryPoint = authenticationEntryPoint;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.httpBasic = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            MediaTypeServerWebExchangeMatcher restMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
            restMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerHttpSecurity.this.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)restMatcher, this.entryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler(this.entryPoint));
            authenticationFilter.setAuthenticationConverter((Function)new ServerHttpBasicAuthenticationConverter());
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private HttpBasicSpec() {
        }
    }

    public class RequestCacheSpec {
        private ServerRequestCache requestCache = new WebSessionServerRequestCache();

        public RequestCacheSpec requestCache(ServerRequestCache requestCache) {
            Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
            this.requestCache = requestCache;
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            ServerRequestCacheWebFilter filter = new ServerRequestCacheWebFilter();
            filter.setRequestCache(this.requestCache);
            http.addFilterAt((WebFilter)filter, SecurityWebFiltersOrder.SERVER_REQUEST_CACHE);
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            this.requestCache = NoOpServerRequestCache.getInstance();
            return this.and();
        }

        private RequestCacheSpec() {
        }
    }

    public class ExceptionHandlingSpec {
        public ExceptionHandlingSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            ServerHttpSecurity.this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public ExceptionHandlingSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            ServerHttpSecurity.this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        private ExceptionHandlingSpec() {
        }
    }

    public class CsrfSpec {
        private CsrfWebFilter filter = new CsrfWebFilter();
        private ServerCsrfTokenRepository csrfTokenRepository = new WebSessionServerCsrfTokenRepository();
        private boolean specifiedRequireCsrfProtectionMatcher;

        public CsrfSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            this.filter.setAccessDeniedHandler(accessDeniedHandler);
            return this;
        }

        public CsrfSpec csrfTokenRepository(ServerCsrfTokenRepository csrfTokenRepository) {
            this.csrfTokenRepository = csrfTokenRepository;
            return this;
        }

        public CsrfSpec requireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
            this.filter.setRequireCsrfProtectionMatcher(requireCsrfProtectionMatcher);
            this.specifiedRequireCsrfProtectionMatcher = true;
            return this;
        }

        public CsrfSpec tokenFromMultipartDataEnabled(boolean enabled) {
            this.filter.setTokenFromMultipartDataEnabled(enabled);
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.csrf = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.csrfTokenRepository != null) {
                this.filter.setCsrfTokenRepository(this.csrfTokenRepository);
                if (ServerHttpSecurity.this.logout != null) {
                    ServerHttpSecurity.this.logout.addLogoutHandler((ServerLogoutHandler)new CsrfServerLogoutHandler(this.csrfTokenRepository));
                }
            }
            http.addFilterAt((WebFilter)this.filter, SecurityWebFiltersOrder.CSRF);
        }

        private CsrfSpec() {
        }
    }

    public class HttpsRedirectSpec {
        private ServerWebExchangeMatcher serverWebExchangeMatcher;
        private PortMapper portMapper;

        public HttpsRedirectSpec httpsRedirectWhen(ServerWebExchangeMatcher ... matchers) {
            this.serverWebExchangeMatcher = new OrServerWebExchangeMatcher(matchers);
            return this;
        }

        public HttpsRedirectSpec httpsRedirectWhen(Function<ServerWebExchange, Boolean> when) {
            ServerWebExchangeMatcher matcher = e -> (Boolean)when.apply(e) != false ? ServerWebExchangeMatcher.MatchResult.match() : ServerWebExchangeMatcher.MatchResult.notMatch();
            return this.httpsRedirectWhen(matcher);
        }

        public HttpsRedirectSpec portMapper(PortMapper portMapper) {
            this.portMapper = portMapper;
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            HttpsRedirectWebFilter httpsRedirectWebFilter = new HttpsRedirectWebFilter();
            if (this.serverWebExchangeMatcher != null) {
                httpsRedirectWebFilter.setRequiresHttpsRedirectMatcher(this.serverWebExchangeMatcher);
            }
            if (this.portMapper != null) {
                httpsRedirectWebFilter.setPortMapper(this.portMapper);
            }
            http.addFilterAt((WebFilter)httpsRedirectWebFilter, SecurityWebFiltersOrder.HTTPS_REDIRECT);
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }
    }

    public class AuthorizeExchangeSpec
    extends AbstractServerWebExchangeMatcherRegistry<Access> {
        private DelegatingReactiveAuthorizationManager.Builder managerBldr = DelegatingReactiveAuthorizationManager.builder();
        private ServerWebExchangeMatcher matcher;
        private boolean anyExchangeRegistered;

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        @Override
        public Access anyExchange() {
            Access result = (Access)super.anyExchange();
            this.anyExchangeRegistered = true;
            return result;
        }

        @Override
        protected Access registerMatcher(ServerWebExchangeMatcher matcher) {
            if (this.anyExchangeRegistered) {
                throw new IllegalStateException("Cannot register " + matcher + " which would be unreachable because anyExchange() has already been registered.");
            }
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + matcher + " does not have an access rule defined");
            }
            this.matcher = matcher;
            return new Access();
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + this.matcher + " does not have an access rule defined");
            }
            AuthorizationWebFilter result = new AuthorizationWebFilter((ReactiveAuthorizationManager)this.managerBldr.build());
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.AUTHORIZATION);
        }

        public final class Access {
            public AuthorizeExchangeSpec permitAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizeExchangeSpec denyAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(false))));
            }

            public AuthorizeExchangeSpec hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasRole((String)role));
            }

            public AuthorizeExchangeSpec hasAnyRole(String ... roles) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyRole((String[])roles));
            }

            public AuthorizeExchangeSpec hasAuthority(String authority) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAuthority((String)authority));
            }

            public AuthorizeExchangeSpec hasAnyAuthority(String ... authorities) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyAuthority((String[])authorities));
            }

            public AuthorizeExchangeSpec authenticated() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthenticatedReactiveAuthorizationManager.authenticated());
            }

            public AuthorizeExchangeSpec access(ReactiveAuthorizationManager<AuthorizationContext> manager) {
                AuthorizeExchangeSpec.this.managerBldr.add(new ServerWebExchangeMatcherEntry(AuthorizeExchangeSpec.this.matcher, manager));
                AuthorizeExchangeSpec.this.matcher = null;
                return AuthorizeExchangeSpec.this;
            }
        }
    }

    public class OAuth2ResourceServerSpec {
        private ServerAuthenticationEntryPoint entryPoint = new BearerTokenServerAuthenticationEntryPoint();
        private ServerAccessDeniedHandler accessDeniedHandler = new BearerTokenServerAccessDeniedHandler();
        private ServerAuthenticationConverter bearerTokenConverter = new ServerBearerTokenAuthenticationConverter();
        private BearerTokenServerWebExchangeMatcher bearerTokenServerWebExchangeMatcher = new BearerTokenServerWebExchangeMatcher();
        private JwtSpec jwt;
        private OpaqueTokenSpec opaqueToken;
        private ReactiveAuthenticationManagerResolver<ServerHttpRequest> authenticationManagerResolver;

        public OAuth2ResourceServerSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            Assert.notNull((Object)accessDeniedHandler, (String)"accessDeniedHandler cannot be null");
            this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        public OAuth2ResourceServerSpec authenticationEntryPoint(ServerAuthenticationEntryPoint entryPoint) {
            Assert.notNull((Object)entryPoint, (String)"entryPoint cannot be null");
            this.entryPoint = entryPoint;
            return this;
        }

        public OAuth2ResourceServerSpec bearerTokenConverter(ServerAuthenticationConverter bearerTokenConverter) {
            Assert.notNull((Object)bearerTokenConverter, (String)"bearerTokenConverter cannot be null");
            this.bearerTokenConverter = bearerTokenConverter;
            return this;
        }

        public OAuth2ResourceServerSpec authenticationManagerResolver(ReactiveAuthenticationManagerResolver<ServerHttpRequest> authenticationManagerResolver) {
            Assert.notNull(authenticationManagerResolver, (String)"authenticationManagerResolver cannot be null");
            this.authenticationManagerResolver = authenticationManagerResolver;
            return this;
        }

        public JwtSpec jwt() {
            if (this.jwt == null) {
                this.jwt = new JwtSpec();
            }
            return this.jwt;
        }

        public OAuth2ResourceServerSpec jwt(Customizer<JwtSpec> jwtCustomizer) {
            if (this.jwt == null) {
                this.jwt = new JwtSpec();
            }
            jwtCustomizer.customize(this.jwt);
            return this;
        }

        public OpaqueTokenSpec opaqueToken() {
            if (this.opaqueToken == null) {
                this.opaqueToken = new OpaqueTokenSpec();
            }
            return this.opaqueToken;
        }

        public OAuth2ResourceServerSpec opaqueToken(Customizer<OpaqueTokenSpec> opaqueTokenCustomizer) {
            if (this.opaqueToken == null) {
                this.opaqueToken = new OpaqueTokenSpec();
            }
            opaqueTokenCustomizer.customize(this.opaqueToken);
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            this.bearerTokenServerWebExchangeMatcher.setBearerTokenConverter(this.bearerTokenConverter);
            this.registerDefaultAccessDeniedHandler(http);
            this.registerDefaultAuthenticationEntryPoint(http);
            this.registerDefaultCsrfOverride(http);
            this.validateConfiguration();
            if (this.authenticationManagerResolver != null) {
                AuthenticationWebFilter oauth2 = new AuthenticationWebFilter(this.authenticationManagerResolver);
                oauth2.setServerAuthenticationConverter(this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler(this.entryPoint));
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            } else if (this.jwt != null) {
                this.jwt.configure(http);
            } else if (this.opaqueToken != null) {
                this.opaqueToken.configure(http);
            }
        }

        private void validateConfiguration() {
            if (this.authenticationManagerResolver == null) {
                if (this.jwt == null && this.opaqueToken == null) {
                    throw new IllegalStateException("Jwt and Opaque Token are the only supported formats for bearer tokens in Spring Security and neither was found. Make sure to configure JWT via http.oauth2ResourceServer().jwt() or Opaque Tokens via http.oauth2ResourceServer().opaqueToken().");
                }
                if (this.jwt != null && this.opaqueToken != null) {
                    throw new IllegalStateException("Spring Security only supports JWTs or Opaque Tokens, not both at the same time.");
                }
            } else if (this.jwt != null || this.opaqueToken != null) {
                throw new IllegalStateException("If an authenticationManagerResolver() is configured, then it takes precedence over any jwt() or opaqueToken() configuration.");
            }
        }

        private void registerDefaultAccessDeniedHandler(ServerHttpSecurity http) {
            if (http.exceptionHandling != null) {
                http.defaultAccessDeniedHandlers.add(new ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry((ServerWebExchangeMatcher)this.bearerTokenServerWebExchangeMatcher, this.accessDeniedHandler));
            }
        }

        private void registerDefaultAuthenticationEntryPoint(ServerHttpSecurity http) {
            if (http.exceptionHandling != null) {
                http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)this.bearerTokenServerWebExchangeMatcher, this.entryPoint));
            }
        }

        private void registerDefaultCsrfOverride(ServerHttpSecurity http) {
            if (http.csrf != null && !http.csrf.specifiedRequireCsrfProtectionMatcher) {
                http.csrf().requireCsrfProtectionMatcher((ServerWebExchangeMatcher)new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{CsrfWebFilter.DEFAULT_CSRF_MATCHER, new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)this.bearerTokenServerWebExchangeMatcher)}));
            }
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public class OpaqueTokenSpec {
            private String introspectionUri;
            private String clientId;
            private String clientSecret;
            private Supplier<ReactiveOpaqueTokenIntrospector> introspector;

            public OpaqueTokenSpec introspectionUri(String introspectionUri) {
                Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
                this.introspectionUri = introspectionUri;
                this.introspector = () -> new NimbusReactiveOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
                return this;
            }

            public OpaqueTokenSpec introspectionClientCredentials(String clientId, String clientSecret) {
                Assert.hasText((String)clientId, (String)"clientId cannot be empty");
                Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
                this.clientId = clientId;
                this.clientSecret = clientSecret;
                this.introspector = () -> new NimbusReactiveOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
                return this;
            }

            public OpaqueTokenSpec introspector(ReactiveOpaqueTokenIntrospector introspector) {
                Assert.notNull((Object)introspector, (String)"introspector cannot be null");
                this.introspector = () -> introspector;
                return this;
            }

            public OAuth2ResourceServerSpec and() {
                return OAuth2ResourceServerSpec.this;
            }

            protected ReactiveAuthenticationManager getAuthenticationManager() {
                return new OpaqueTokenReactiveAuthenticationManager(this.getIntrospector());
            }

            protected ReactiveOpaqueTokenIntrospector getIntrospector() {
                if (this.introspector != null) {
                    return this.introspector.get();
                }
                return (ReactiveOpaqueTokenIntrospector)ServerHttpSecurity.this.getBean(ReactiveOpaqueTokenIntrospector.class);
            }

            protected void configure(ServerHttpSecurity http) {
                ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
                BearerTokenAuthenticationWebFilter oauth2 = new BearerTokenAuthenticationWebFilter(authenticationManager);
                oauth2.setServerAuthenticationConverter(OAuth2ResourceServerSpec.this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler(OAuth2ResourceServerSpec.this.entryPoint));
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            }

            private OpaqueTokenSpec() {
            }
        }

        public class JwtSpec {
            private ReactiveAuthenticationManager authenticationManager;
            private ReactiveJwtDecoder jwtDecoder;
            private Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter = new ReactiveJwtAuthenticationConverterAdapter((Converter)new JwtAuthenticationConverter());

            public JwtSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
                Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
                this.authenticationManager = authenticationManager;
                return this;
            }

            public JwtSpec jwtAuthenticationConverter(Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
                Assert.notNull(jwtAuthenticationConverter, (String)"jwtAuthenticationConverter cannot be null");
                this.jwtAuthenticationConverter = jwtAuthenticationConverter;
                return this;
            }

            public JwtSpec jwtDecoder(ReactiveJwtDecoder jwtDecoder) {
                this.jwtDecoder = jwtDecoder;
                return this;
            }

            public JwtSpec publicKey(RSAPublicKey publicKey) {
                this.jwtDecoder = new NimbusReactiveJwtDecoder(publicKey);
                return this;
            }

            public JwtSpec jwkSetUri(String jwkSetUri) {
                this.jwtDecoder = new NimbusReactiveJwtDecoder(jwkSetUri);
                return this;
            }

            public OAuth2ResourceServerSpec and() {
                return OAuth2ResourceServerSpec.this;
            }

            protected void configure(ServerHttpSecurity http) {
                ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
                BearerTokenAuthenticationWebFilter oauth2 = new BearerTokenAuthenticationWebFilter(authenticationManager);
                oauth2.setServerAuthenticationConverter(OAuth2ResourceServerSpec.this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler(OAuth2ResourceServerSpec.this.entryPoint));
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            }

            protected ReactiveJwtDecoder getJwtDecoder() {
                if (this.jwtDecoder == null) {
                    return (ReactiveJwtDecoder)ServerHttpSecurity.this.getBean(ReactiveJwtDecoder.class);
                }
                return this.jwtDecoder;
            }

            protected Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> getJwtAuthenticationConverter() {
                return this.jwtAuthenticationConverter;
            }

            private ReactiveAuthenticationManager getAuthenticationManager() {
                if (this.authenticationManager != null) {
                    return this.authenticationManager;
                }
                ReactiveJwtDecoder jwtDecoder = this.getJwtDecoder();
                Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter = this.getJwtAuthenticationConverter();
                JwtReactiveAuthenticationManager authenticationManager = new JwtReactiveAuthenticationManager(jwtDecoder);
                authenticationManager.setJwtAuthenticationConverter(jwtAuthenticationConverter);
                return authenticationManager;
            }
        }

        private class BearerTokenAuthenticationWebFilter
        extends AuthenticationWebFilter {
            private ServerAuthenticationFailureHandler authenticationFailureHandler;

            BearerTokenAuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager) {
                super(authenticationManager);
            }

            public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
                WebFilterExchange webFilterExchange = new WebFilterExchange(exchange, chain);
                return super.filter(exchange, chain).onErrorResume(AuthenticationException.class, e -> this.authenticationFailureHandler.onAuthenticationFailure(webFilterExchange, e));
            }

            public void setAuthenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
                super.setAuthenticationFailureHandler(authenticationFailureHandler);
                this.authenticationFailureHandler = authenticationFailureHandler;
            }
        }

        private class BearerTokenServerWebExchangeMatcher
        implements ServerWebExchangeMatcher {
            ServerAuthenticationConverter bearerTokenConverter;

            private BearerTokenServerWebExchangeMatcher() {
            }

            public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
                return this.bearerTokenConverter.convert(exchange).flatMap(this::nullAuthentication).onErrorResume(e -> ServerWebExchangeMatcher.MatchResult.notMatch());
            }

            public void setBearerTokenConverter(ServerAuthenticationConverter bearerTokenConverter) {
                Assert.notNull((Object)bearerTokenConverter, (String)"bearerTokenConverter cannot be null");
                this.bearerTokenConverter = bearerTokenConverter;
            }

            private Mono<ServerWebExchangeMatcher.MatchResult> nullAuthentication(Authentication authentication) {
                return authentication == null ? ServerWebExchangeMatcher.MatchResult.notMatch() : ServerWebExchangeMatcher.MatchResult.match();
            }
        }
    }

    public class OAuth2ClientSpec {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ServerAuthenticationConverter authenticationConverter;
        private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;

        public OAuth2ClientSpec authenticationConverter(ServerAuthenticationConverter authenticationConverter) {
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        private ServerAuthenticationConverter getAuthenticationConverter() {
            if (this.authenticationConverter == null) {
                ServerOAuth2AuthorizationCodeAuthenticationTokenConverter authenticationConverter = new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(this.getClientRegistrationRepository());
                authenticationConverter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
                this.authenticationConverter = authenticationConverter;
            }
            return this.authenticationConverter;
        }

        public OAuth2ClientSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                this.authenticationManager = new OAuth2AuthorizationCodeReactiveAuthenticationManager((ReactiveOAuth2AccessTokenResponseClient)new WebClientReactiveAuthorizationCodeTokenResponseClient());
            }
            return this.authenticationManager;
        }

        public OAuth2ClientSpec clientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            this.clientRegistrationRepository = clientRegistrationRepository;
            return this;
        }

        public OAuth2ClientSpec authorizedClientRepository(ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            this.authorizedClientRepository = authorizedClientRepository;
            return this;
        }

        public OAuth2ClientSpec authorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> getAuthorizationRequestRepository() {
            if (this.authorizationRequestRepository == null) {
                this.authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
            }
            return this.authorizationRequestRepository;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ReactiveClientRegistrationRepository clientRegistrationRepository = this.getClientRegistrationRepository();
            ServerOAuth2AuthorizedClientRepository authorizedClientRepository = this.getAuthorizedClientRepository();
            ServerAuthenticationConverter authenticationConverter = this.getAuthenticationConverter();
            ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
            OAuth2AuthorizationCodeGrantWebFilter codeGrantWebFilter = new OAuth2AuthorizationCodeGrantWebFilter(authenticationManager, authenticationConverter, authorizedClientRepository);
            codeGrantWebFilter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
            OAuth2AuthorizationRequestRedirectWebFilter oauthRedirectFilter = new OAuth2AuthorizationRequestRedirectWebFilter(clientRegistrationRepository);
            oauthRedirectFilter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
            http.addFilterAt((WebFilter)codeGrantWebFilter, SecurityWebFiltersOrder.OAUTH2_AUTHORIZATION_CODE);
            http.addFilterAt((WebFilter)oauthRedirectFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private ReactiveClientRegistrationRepository getClientRegistrationRepository() {
            if (this.clientRegistrationRepository != null) {
                return this.clientRegistrationRepository;
            }
            return (ReactiveClientRegistrationRepository)ServerHttpSecurity.this.getBeanOrNull(ReactiveClientRegistrationRepository.class);
        }

        private ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository() {
            ReactiveOAuth2AuthorizedClientService authorizedClientService;
            if (this.authorizedClientRepository != null) {
                return this.authorizedClientRepository;
            }
            ServerOAuth2AuthorizedClientRepository result = (ServerOAuth2AuthorizedClientRepository)ServerHttpSecurity.this.getBeanOrNull(ServerOAuth2AuthorizedClientRepository.class);
            if (result == null && (authorizedClientService = this.getAuthorizedClientService()) != null) {
                result = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            }
            return result;
        }

        private ReactiveOAuth2AuthorizedClientService getAuthorizedClientService() {
            ReactiveOAuth2AuthorizedClientService service = (ReactiveOAuth2AuthorizedClientService)ServerHttpSecurity.this.getBeanOrNull(ReactiveOAuth2AuthorizedClientService.class);
            if (service == null) {
                service = new InMemoryReactiveOAuth2AuthorizedClientService(this.getClientRegistrationRepository());
            }
            return service;
        }

        private OAuth2ClientSpec() {
        }
    }

    public class OAuth2LoginSpec {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationConverter authenticationConverter;
        private ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver;
        private ServerWebExchangeMatcher authenticationMatcher;
        private ServerAuthenticationSuccessHandler authenticationSuccessHandler;
        private ServerAuthenticationFailureHandler authenticationFailureHandler;

        public OAuth2LoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public OAuth2LoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public OAuth2LoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler = authenticationSuccessHandler;
            return this;
        }

        public OAuth2LoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                this.authenticationManager = this.createDefault();
            }
            return this.authenticationManager;
        }

        private ReactiveAuthenticationManager createDefault() {
            ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> client = this.getAccessTokenResponseClient();
            OAuth2LoginReactiveAuthenticationManager result = new OAuth2LoginReactiveAuthenticationManager(client, this.getOauth2UserService());
            boolean oidcAuthenticationProviderEnabled = ClassUtils.isPresent((String)"org.springframework.security.oauth2.jwt.JwtDecoder", (ClassLoader)this.getClass().getClassLoader());
            if (oidcAuthenticationProviderEnabled) {
                OidcAuthorizationCodeReactiveAuthenticationManager oidc = new OidcAuthorizationCodeReactiveAuthenticationManager(client, this.getOidcUserService());
                ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveJwtDecoderFactory.class, (Class[])new Class[]{ClientRegistration.class});
                ReactiveJwtDecoderFactory jwtDecoderFactory = (ReactiveJwtDecoderFactory)ServerHttpSecurity.this.getBeanOrNull(type);
                if (jwtDecoderFactory != null) {
                    oidc.setJwtDecoderFactory(jwtDecoderFactory);
                }
                result = new DelegatingReactiveAuthenticationManager(new ReactiveAuthenticationManager[]{oidc, result});
            }
            return result;
        }

        public OAuth2LoginSpec authenticationConverter(ServerAuthenticationConverter authenticationConverter) {
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        private ServerAuthenticationConverter getAuthenticationConverter(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            if (this.authenticationConverter == null) {
                ServerOAuth2AuthorizationCodeAuthenticationTokenConverter authenticationConverter = new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(clientRegistrationRepository);
                authenticationConverter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
                this.authenticationConverter = authenticationConverter;
            }
            return this.authenticationConverter;
        }

        public OAuth2LoginSpec clientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            this.clientRegistrationRepository = clientRegistrationRepository;
            return this;
        }

        public OAuth2LoginSpec authorizedClientService(ReactiveOAuth2AuthorizedClientService authorizedClientService) {
            this.authorizedClientRepository = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            return this;
        }

        public OAuth2LoginSpec authorizedClientRepository(ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            this.authorizedClientRepository = authorizedClientRepository;
            return this;
        }

        public OAuth2LoginSpec authorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        public OAuth2LoginSpec authorizationRequestResolver(ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            this.authorizationRequestResolver = authorizationRequestResolver;
            return this;
        }

        public OAuth2LoginSpec authenticationMatcher(ServerWebExchangeMatcher authenticationMatcher) {
            this.authenticationMatcher = authenticationMatcher;
            return this;
        }

        private ServerWebExchangeMatcher getAuthenticationMatcher() {
            if (this.authenticationMatcher == null) {
                this.authenticationMatcher = this.createAttemptAuthenticationRequestMatcher();
            }
            return this.authenticationMatcher;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ReactiveClientRegistrationRepository clientRegistrationRepository = this.getClientRegistrationRepository();
            ServerOAuth2AuthorizedClientRepository authorizedClientRepository = this.getAuthorizedClientRepository();
            OAuth2AuthorizationRequestRedirectWebFilter oauthRedirectFilter = this.getRedirectWebFilter();
            ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = this.getAuthorizationRequestRepository();
            oauthRedirectFilter.setAuthorizationRequestRepository(authorizationRequestRepository);
            oauthRedirectFilter.setRequestCache(http.requestCache.requestCache);
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            OAuth2LoginAuthenticationWebFilter authenticationFilter = new OAuth2LoginAuthenticationWebFilter(manager, authorizedClientRepository);
            authenticationFilter.setRequiresAuthenticationMatcher(this.getAuthenticationMatcher());
            authenticationFilter.setServerAuthenticationConverter(this.getAuthenticationConverter(clientRegistrationRepository));
            authenticationFilter.setAuthenticationSuccessHandler(this.getAuthenticationSuccessHandler(http));
            authenticationFilter.setAuthenticationFailureHandler(this.getAuthenticationFailureHandler());
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            this.setDefaultEntryPoints(http);
            http.addFilterAt((WebFilter)oauthRedirectFilter, SecurityWebFiltersOrder.HTTP_BASIC);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private void setDefaultEntryPoints(ServerHttpSecurity http) {
            String defaultLoginPage = "/login";
            Map<String, String> urlToText = http.oauth2Login.getLinks();
            String providerLoginPage = null;
            if (urlToText.size() == 1) {
                providerLoginPage = urlToText.keySet().iterator().next();
            }
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerWebExchangeMatcher xhrMatcher = exchange -> {
                if (exchange.getRequest().getHeaders().getOrEmpty((Object)"X-Requested-With").contains("XMLHttpRequest")) {
                    return ServerWebExchangeMatcher.MatchResult.match();
                }
                return ServerWebExchangeMatcher.MatchResult.notMatch();
            };
            NegatedServerWebExchangeMatcher notXhrMatcher = new NegatedServerWebExchangeMatcher(xhrMatcher);
            AndServerWebExchangeMatcher defaultEntryPointMatcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notXhrMatcher, htmlMatcher});
            if (providerLoginPage != null) {
                PathPatternParserServerWebExchangeMatcher loginPageMatcher = new PathPatternParserServerWebExchangeMatcher(defaultLoginPage);
                PathPatternParserServerWebExchangeMatcher faviconMatcher = new PathPatternParserServerWebExchangeMatcher("/favicon.ico");
                AndServerWebExchangeMatcher defaultLoginPageMatcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{new OrServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{loginPageMatcher, faviconMatcher}), defaultEntryPointMatcher});
                AndServerWebExchangeMatcher matcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notXhrMatcher, new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)defaultLoginPageMatcher)});
                RedirectServerAuthenticationEntryPoint entryPoint = new RedirectServerAuthenticationEntryPoint(providerLoginPage);
                entryPoint.setRequestCache(http.requestCache.requestCache);
                http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)matcher, (ServerAuthenticationEntryPoint)entryPoint));
            }
            RedirectServerAuthenticationEntryPoint defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(defaultLoginPage);
            defaultEntryPoint.setRequestCache(http.requestCache.requestCache);
            http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)defaultEntryPointMatcher, (ServerAuthenticationEntryPoint)defaultEntryPoint));
        }

        private ServerAuthenticationSuccessHandler getAuthenticationSuccessHandler(ServerHttpSecurity http) {
            if (this.authenticationSuccessHandler == null) {
                RedirectServerAuthenticationSuccessHandler handler = new RedirectServerAuthenticationSuccessHandler();
                handler.setRequestCache(http.requestCache.requestCache);
                this.authenticationSuccessHandler = handler;
            }
            return this.authenticationSuccessHandler;
        }

        private ServerAuthenticationFailureHandler getAuthenticationFailureHandler() {
            if (this.authenticationFailureHandler == null) {
                this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler("/login?error");
            }
            return this.authenticationFailureHandler;
        }

        private ServerWebExchangeMatcher createAttemptAuthenticationRequestMatcher() {
            return new PathPatternParserServerWebExchangeMatcher("/login/oauth2/code/{registrationId}");
        }

        private ReactiveOAuth2UserService<OidcUserRequest, OidcUser> getOidcUserService() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2UserService.class, (Class[])new Class[]{OidcUserRequest.class, OidcUser.class});
            ReactiveOAuth2UserService bean = (ReactiveOAuth2UserService)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean == null) {
                return new OidcReactiveOAuth2UserService();
            }
            return bean;
        }

        private ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> getOauth2UserService() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2UserService.class, (Class[])new Class[]{OAuth2UserRequest.class, OAuth2User.class});
            ReactiveOAuth2UserService bean = (ReactiveOAuth2UserService)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean == null) {
                return new DefaultReactiveOAuth2UserService();
            }
            return bean;
        }

        private Map<String, String> getLinks() {
            Iterable registrations = (Iterable)ServerHttpSecurity.this.getBeanOrNull(ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{ClientRegistration.class}));
            if (registrations == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            registrations.iterator().forEachRemaining(r -> result.put("/oauth2/authorization/" + r.getRegistrationId(), r.getClientName()));
            return result;
        }

        private ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> getAccessTokenResponseClient() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2AuthorizationCodeGrantRequest.class});
            ReactiveOAuth2AccessTokenResponseClient bean = (ReactiveOAuth2AccessTokenResponseClient)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean == null) {
                return new WebClientReactiveAuthorizationCodeTokenResponseClient();
            }
            return bean;
        }

        private ReactiveClientRegistrationRepository getClientRegistrationRepository() {
            if (this.clientRegistrationRepository == null) {
                this.clientRegistrationRepository = (ReactiveClientRegistrationRepository)ServerHttpSecurity.this.getBeanOrNull(ReactiveClientRegistrationRepository.class);
            }
            return this.clientRegistrationRepository;
        }

        private OAuth2AuthorizationRequestRedirectWebFilter getRedirectWebFilter() {
            OAuth2AuthorizationRequestRedirectWebFilter oauthRedirectFilter = this.authorizationRequestResolver == null ? new OAuth2AuthorizationRequestRedirectWebFilter(this.getClientRegistrationRepository()) : new OAuth2AuthorizationRequestRedirectWebFilter(this.authorizationRequestResolver);
            return oauthRedirectFilter;
        }

        private ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository() {
            ReactiveOAuth2AuthorizedClientService authorizedClientService;
            ServerOAuth2AuthorizedClientRepository result = this.authorizedClientRepository;
            if (result == null) {
                result = (ServerOAuth2AuthorizedClientRepository)ServerHttpSecurity.this.getBeanOrNull(ServerOAuth2AuthorizedClientRepository.class);
            }
            if (result == null && (authorizedClientService = this.getAuthorizedClientService()) != null) {
                result = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            }
            return result;
        }

        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> getAuthorizationRequestRepository() {
            if (this.authorizationRequestRepository == null) {
                this.authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
            }
            return this.authorizationRequestRepository;
        }

        private ReactiveOAuth2AuthorizedClientService getAuthorizedClientService() {
            ReactiveOAuth2AuthorizedClientService service = (ReactiveOAuth2AuthorizedClientService)ServerHttpSecurity.this.getBeanOrNull(ReactiveOAuth2AuthorizedClientService.class);
            if (service == null) {
                service = new InMemoryReactiveOAuth2AuthorizedClientService(this.getClientRegistrationRepository());
            }
            return service;
        }

        private OAuth2LoginSpec() {
        }
    }

    public class X509Spec {
        private X509PrincipalExtractor principalExtractor;
        private ReactiveAuthenticationManager authenticationManager;

        public X509Spec principalExtractor(X509PrincipalExtractor principalExtractor) {
            this.principalExtractor = principalExtractor;
            return this;
        }

        public X509Spec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
            X509PrincipalExtractor principalExtractor = this.getPrincipalExtractor();
            AuthenticationWebFilter filter = new AuthenticationWebFilter(authenticationManager);
            filter.setServerAuthenticationConverter((ServerAuthenticationConverter)new ServerX509AuthenticationConverter(principalExtractor));
            http.addFilterAt((WebFilter)filter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private X509PrincipalExtractor getPrincipalExtractor() {
            if (this.principalExtractor != null) {
                return this.principalExtractor;
            }
            return new SubjectDnX509PrincipalExtractor();
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            ReactiveUserDetailsService userDetailsService = (ReactiveUserDetailsService)ServerHttpSecurity.this.getBean(ReactiveUserDetailsService.class);
            ReactivePreAuthenticatedAuthenticationManager authenticationManager = new ReactivePreAuthenticatedAuthenticationManager(userDetailsService);
            return authenticationManager;
        }

        private X509Spec() {
        }
    }

    public class CorsSpec {
        private CorsWebFilter corsFilter;

        public CorsSpec configurationSource(CorsConfigurationSource source) {
            this.corsFilter = new CorsWebFilter(source);
            return this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.cors = null;
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            CorsWebFilter corsFilter = this.getCorsFilter();
            if (corsFilter != null) {
                http.addFilterAt((WebFilter)this.corsFilter, SecurityWebFiltersOrder.CORS);
            }
        }

        private CorsWebFilter getCorsFilter() {
            if (this.corsFilter != null) {
                return this.corsFilter;
            }
            CorsConfigurationSource source = (CorsConfigurationSource)ServerHttpSecurity.this.getBeanOrNull(CorsConfigurationSource.class);
            if (source == null) {
                return null;
            }
            CorsProcessor processor = (CorsProcessor)ServerHttpSecurity.this.getBeanOrNull(CorsProcessor.class);
            if (processor == null) {
                processor = new DefaultCorsProcessor();
            }
            this.corsFilter = new CorsWebFilter(source, processor);
            return this.corsFilter;
        }

        private CorsSpec() {
        }
    }
}

