/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChainMapBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        BeanDefinition filterChainProxy = holder.getBeanDefinition();
        ManagedList securityFilterChains = new ManagedList();
        Element elt = (Element)node;
        MatcherType matcherType = MatcherType.fromElement(elt);
        List filterChainElts = DomUtils.getChildElementsByTagName((Element)elt, (String)"filter-chain");
        for (Element chain : filterChainElts) {
            String path = chain.getAttribute("pattern");
            String filters = chain.getAttribute("filters");
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("The attribute 'pattern' must not be empty", (Object)elt);
            }
            if (!StringUtils.hasText((String)filters)) {
                parserContext.getReaderContext().error("The attribute 'filters'must not be empty", (Object)elt);
            }
            BeanDefinition matcher = matcherType.createMatcher(path, null);
            if (filters.equals("none")) {
                securityFilterChains.add((Object)this.createSecurityFilterChain(matcher, new ManagedList(0)));
                continue;
            }
            String[] filterBeanNames = StringUtils.tokenizeToStringArray((String)filters, (String)",");
            ManagedList filterChain = new ManagedList(filterBeanNames.length);
            for (String name : filterBeanNames) {
                filterChain.add((Object)new RuntimeBeanReference(name));
            }
            securityFilterChains.add((Object)this.createSecurityFilterChain(matcher, filterChain));
        }
        filterChainProxy.getConstructorArgumentValues().addGenericArgumentValue((Object)securityFilterChains);
        return holder;
    }

    private BeanDefinition createSecurityFilterChain(BeanDefinition matcher, ManagedList<?> filters) {
        BeanDefinitionBuilder sfc = BeanDefinitionBuilder.rootBeanDefinition(DefaultSecurityFilterChain.class);
        sfc.addConstructorArgValue((Object)matcher);
        sfc.addConstructorArgValue(filters);
        return sfc.getBeanDefinition();
    }
}

