/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.domain.DefaultPermissionGrantingStrategy;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.UnloadedSidException;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public final class BasicLookupStrategy
implements LookupStrategy {
    public static final String DEFAULT_SELECT_CLAUSE = "select acl_object_identity.object_id_identity, acl_entry.ace_order,  acl_object_identity.id as acl_id, acl_object_identity.parent_object, acl_object_identity.entries_inheriting, acl_entry.id as ace_id, acl_entry.mask,  acl_entry.granting,  acl_entry.audit_success, acl_entry.audit_failure,  acl_sid.principal as ace_principal, acl_sid.sid as ace_sid,  acli_sid.principal as acl_principal, acli_sid.sid as acl_sid, acl_class.class from acl_object_identity left join acl_sid acli_sid on acli_sid.id = acl_object_identity.owner_sid left join acl_class on acl_class.id = acl_object_identity.object_id_class   left join acl_entry on acl_object_identity.id = acl_entry.acl_object_identity left join acl_sid on acl_entry.sid = acl_sid.id  where ( ";
    private static final String DEFAULT_LOOKUP_KEYS_WHERE_CLAUSE = "(acl_object_identity.id = ?)";
    private static final String DEFAULT_LOOKUP_IDENTITIES_WHERE_CLAUSE = "(acl_object_identity.object_id_identity = ? and acl_class.class = ?)";
    public static final String DEFAULT_ORDER_BY_CLAUSE = ") order by acl_object_identity.object_id_identity asc, acl_entry.ace_order asc";
    private final AclAuthorizationStrategy aclAuthorizationStrategy;
    private PermissionFactory permissionFactory = new DefaultPermissionFactory();
    private final AclCache aclCache;
    private final PermissionGrantingStrategy grantingStrategy;
    private final JdbcTemplate jdbcTemplate;
    private int batchSize = 50;
    private final Field fieldAces = FieldUtils.getField(AclImpl.class, (String)"aces");
    private final Field fieldAcl = FieldUtils.getField(AccessControlEntryImpl.class, (String)"acl");
    private String selectClause = "select acl_object_identity.object_id_identity, acl_entry.ace_order,  acl_object_identity.id as acl_id, acl_object_identity.parent_object, acl_object_identity.entries_inheriting, acl_entry.id as ace_id, acl_entry.mask,  acl_entry.granting,  acl_entry.audit_success, acl_entry.audit_failure,  acl_sid.principal as ace_principal, acl_sid.sid as ace_sid,  acli_sid.principal as acl_principal, acli_sid.sid as acl_sid, acl_class.class from acl_object_identity left join acl_sid acli_sid on acli_sid.id = acl_object_identity.owner_sid left join acl_class on acl_class.id = acl_object_identity.object_id_class   left join acl_entry on acl_object_identity.id = acl_entry.acl_object_identity left join acl_sid on acl_entry.sid = acl_sid.id  where ( ";
    private String lookupPrimaryKeysWhereClause = "(acl_object_identity.id = ?)";
    private String lookupObjectIdentitiesWhereClause = "(acl_object_identity.object_id_identity = ? and acl_class.class = ?)";
    private String orderByClause = ") order by acl_object_identity.object_id_identity asc, acl_entry.ace_order asc";

    @Deprecated
    public BasicLookupStrategy(DataSource dataSource, AclCache aclCache, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        this(dataSource, aclCache, aclAuthorizationStrategy, new DefaultPermissionGrantingStrategy(auditLogger));
    }

    public BasicLookupStrategy(DataSource dataSource, AclCache aclCache, AclAuthorizationStrategy aclAuthorizationStrategy, PermissionGrantingStrategy grantingStrategy) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)aclCache, (String)"AclCache required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)grantingStrategy, (String)"grantingStrategy required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.aclCache = aclCache;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.grantingStrategy = grantingStrategy;
        this.fieldAces.setAccessible(true);
        this.fieldAcl.setAccessible(true);
    }

    private String computeRepeatingSql(String repeatingSql, int requiredRepetitions) {
        assert (requiredRepetitions > 0) : "requiredRepetitions must be > 0";
        String startSql = this.selectClause;
        String endSql = this.orderByClause;
        StringBuilder sqlStringBldr = new StringBuilder(startSql.length() + endSql.length() + requiredRepetitions * (repeatingSql.length() + 4));
        sqlStringBldr.append(startSql);
        for (int i = 1; i <= requiredRepetitions; ++i) {
            sqlStringBldr.append(repeatingSql);
            if (i == requiredRepetitions) continue;
            sqlStringBldr.append(" or ");
        }
        sqlStringBldr.append(endSql);
        return sqlStringBldr.toString();
    }

    private List<AccessControlEntryImpl> readAces(AclImpl acl) {
        try {
            return (List)this.fieldAces.get(acl);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not obtain AclImpl.aces field", e);
        }
    }

    private void setAclOnAce(AccessControlEntryImpl ace, AclImpl acl) {
        try {
            this.fieldAcl.set(ace, acl);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not or set AclImpl on AccessControlEntryImpl fields", e);
        }
    }

    private void setAces(AclImpl acl, List<AccessControlEntryImpl> aces) {
        try {
            this.fieldAces.set(acl, aces);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not set AclImpl entries", e);
        }
    }

    private void lookupPrimaryKeys(Map<Serializable, Acl> acls, final Set<Long> findNow, List<Sid> sids) {
        Assert.notNull(acls, (String)"ACLs are required");
        Assert.notEmpty(findNow, (String)"Items to find now required");
        String sql = this.computeRepeatingSql(this.lookupPrimaryKeysWhereClause, findNow.size());
        Set parentsToLookup = (Set)this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int i = 0;
                for (Long toFind : findNow) {
                    ps.setLong(++i, toFind);
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
        if (parentsToLookup.size() > 0) {
            this.lookupPrimaryKeys(acls, parentsToLookup, sids);
        }
    }

    @Override
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects, List<Sid> sids) {
        Assert.isTrue((this.batchSize >= 1 ? 1 : 0) != 0, (String)"BatchSize must be >= 1");
        Assert.notEmpty(objects, (String)"Objects to lookup required");
        HashMap<ObjectIdentity, Acl> result = new HashMap<ObjectIdentity, Acl>();
        HashSet<ObjectIdentity> currentBatchToLoad = new HashSet<ObjectIdentity>();
        for (int i = 0; i < objects.size(); ++i) {
            MutableAcl acl;
            ObjectIdentity oid = objects.get(i);
            boolean aclFound = false;
            if (result.containsKey(oid)) {
                aclFound = true;
            }
            if (!aclFound && (acl = this.aclCache.getFromCache(oid)) != null) {
                if (acl.isSidLoaded(sids)) {
                    result.put(acl.getObjectIdentity(), acl);
                    aclFound = true;
                } else {
                    throw new IllegalStateException("Error: SID-filtered element detected when implementation does not perform SID filtering - have you added something to the cache manually?");
                }
            }
            if (!aclFound) {
                currentBatchToLoad.add(oid);
            }
            if (currentBatchToLoad.size() != this.batchSize && i + 1 != objects.size() || currentBatchToLoad.size() <= 0) continue;
            Map<ObjectIdentity, Acl> loadedBatch = this.lookupObjectIdentities(currentBatchToLoad, sids);
            result.putAll(loadedBatch);
            for (Acl loadedAcl : loadedBatch.values()) {
                this.aclCache.putInCache((AclImpl)loadedAcl);
            }
            currentBatchToLoad.clear();
        }
        return result;
    }

    private Map<ObjectIdentity, Acl> lookupObjectIdentities(final Collection<ObjectIdentity> objectIdentities, List<Sid> sids) {
        Assert.notEmpty(objectIdentities, (String)"Must provide identities to lookup");
        HashMap<Serializable, Acl> acls = new HashMap<Serializable, Acl>();
        String sql = this.computeRepeatingSql(this.lookupObjectIdentitiesWhereClause, objectIdentities.size());
        Set parentsToLookup = (Set)this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int i = 0;
                for (ObjectIdentity oid : objectIdentities) {
                    String type = oid.getType();
                    String identifier = oid.getIdentifier().toString();
                    long id = Long.valueOf(identifier);
                    ps.setLong(2 * i + 1, id);
                    ps.setString(2 * i + 2, type);
                    ++i;
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
        if (parentsToLookup.size() > 0) {
            this.lookupPrimaryKeys(acls, parentsToLookup, sids);
        }
        HashMap<ObjectIdentity, Acl> resultMap = new HashMap<ObjectIdentity, Acl>();
        for (Acl inputAcl : acls.values()) {
            Assert.isInstanceOf(AclImpl.class, (Object)inputAcl, (String)"Map should have contained an AclImpl");
            Assert.isInstanceOf(Long.class, (Object)((AclImpl)inputAcl).getId(), (String)"Acl.getId() must be Long");
            AclImpl result = this.convert(acls, (Long)((AclImpl)inputAcl).getId());
            resultMap.put(result.getObjectIdentity(), result);
        }
        return resultMap;
    }

    private AclImpl convert(Map<Serializable, Acl> inputMap, Long currentIdentity) {
        Assert.notEmpty(inputMap, (String)"InputMap required");
        Assert.notNull((Object)currentIdentity, (String)"CurrentIdentity required");
        Acl uncastAcl = inputMap.get(currentIdentity);
        Assert.isInstanceOf(AclImpl.class, (Object)uncastAcl, (String)"The inputMap contained a non-AclImpl");
        AclImpl inputAcl = (AclImpl)uncastAcl;
        Acl parent = inputAcl.getParentAcl();
        if (parent != null && parent instanceof StubAclParent) {
            StubAclParent stubAclParent = (StubAclParent)parent;
            parent = this.convert(inputMap, stubAclParent.getId());
        }
        AclImpl result = new AclImpl(inputAcl.getObjectIdentity(), (Serializable)((Long)inputAcl.getId()), this.aclAuthorizationStrategy, this.grantingStrategy, parent, null, inputAcl.isEntriesInheriting(), inputAcl.getOwner());
        List<AccessControlEntryImpl> aces = this.readAces(inputAcl);
        ArrayList<AccessControlEntryImpl> acesNew = new ArrayList<AccessControlEntryImpl>();
        for (AccessControlEntryImpl ace : aces) {
            this.setAclOnAce(ace, result);
            acesNew.add(ace);
        }
        this.setAces(result, acesNew);
        return result;
    }

    public void setPermissionFactory(PermissionFactory permissionFactory) {
        this.permissionFactory = permissionFactory;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public void setLookupPrimaryKeysWhereClause(String lookupPrimaryKeysWhereClause) {
        this.lookupPrimaryKeysWhereClause = lookupPrimaryKeysWhereClause;
    }

    public void setLookupObjectIdentitiesWhereClause(String lookupObjectIdentitiesWhereClause) {
        this.lookupObjectIdentitiesWhereClause = lookupObjectIdentitiesWhereClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    private class StubAclParent
    implements Acl {
        private final Long id;

        public StubAclParent(Long id) {
            this.id = id;
        }

        @Override
        public List<AccessControlEntry> getEntries() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public ObjectIdentity getObjectIdentity() {
            throw new UnsupportedOperationException("Stub only");
        }

        @Override
        public Sid getOwner() {
            throw new UnsupportedOperationException("Stub only");
        }

        @Override
        public Acl getParentAcl() {
            throw new UnsupportedOperationException("Stub only");
        }

        @Override
        public boolean isEntriesInheriting() {
            throw new UnsupportedOperationException("Stub only");
        }

        @Override
        public boolean isGranted(List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
            throw new UnsupportedOperationException("Stub only");
        }

        @Override
        public boolean isSidLoaded(List<Sid> sids) {
            throw new UnsupportedOperationException("Stub only");
        }
    }

    private class ProcessResultSet
    implements ResultSetExtractor<Set<Long>> {
        private final Map<Serializable, Acl> acls;
        private final List<Sid> sids;

        public ProcessResultSet(Map<Serializable, Acl> acls, List<Sid> sids) {
            Assert.notNull(acls, (String)"ACLs cannot be null");
            this.acls = acls;
            this.sids = sids;
        }

        public Set<Long> extractData(ResultSet rs) throws SQLException {
            HashSet<Long> parentIdsToLookup = new HashSet<Long>();
            while (rs.next()) {
                this.convertCurrentResultIntoObject(this.acls, rs);
                long parentId = rs.getLong("parent_object");
                if (parentId == 0L || this.acls.containsKey(new Long(parentId))) continue;
                MutableAcl cached = BasicLookupStrategy.this.aclCache.getFromCache(new Long(parentId));
                if (cached == null || !cached.isSidLoaded(this.sids)) {
                    parentIdsToLookup.add(new Long(parentId));
                    continue;
                }
                this.acls.put(cached.getId(), cached);
            }
            return parentIdsToLookup;
        }

        private void convertCurrentResultIntoObject(Map<Serializable, Acl> acls, ResultSet rs) throws SQLException {
            Long id = new Long(rs.getLong("acl_id"));
            Acl acl = acls.get(id);
            if (acl == null) {
                ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(rs.getString("class"), (Serializable)Long.valueOf(rs.getLong("object_id_identity")));
                StubAclParent parentAcl = null;
                long parentAclId = rs.getLong("parent_object");
                if (parentAclId != 0L) {
                    parentAcl = new StubAclParent(parentAclId);
                }
                boolean entriesInheriting = rs.getBoolean("entries_inheriting");
                Sid owner = rs.getBoolean("acl_principal") ? new PrincipalSid(rs.getString("acl_sid")) : new GrantedAuthoritySid(rs.getString("acl_sid"));
                acl = new AclImpl((ObjectIdentity)objectIdentity, (Serializable)id, BasicLookupStrategy.this.aclAuthorizationStrategy, BasicLookupStrategy.this.grantingStrategy, (Acl)parentAcl, null, entriesInheriting, owner);
                acls.put(id, acl);
            }
            if (rs.getString("ace_sid") != null) {
                Long aceId = new Long(rs.getLong("ace_id"));
                Sid recipient = rs.getBoolean("ace_principal") ? new PrincipalSid(rs.getString("ace_sid")) : new GrantedAuthoritySid(rs.getString("ace_sid"));
                int mask = rs.getInt("mask");
                Permission permission = BasicLookupStrategy.this.permissionFactory.buildFromMask(mask);
                boolean granting = rs.getBoolean("granting");
                boolean auditSuccess = rs.getBoolean("audit_success");
                boolean auditFailure = rs.getBoolean("audit_failure");
                AccessControlEntryImpl ace = new AccessControlEntryImpl(aceId, acl, recipient, permission, granting, auditSuccess, auditFailure);
                List aces = BasicLookupStrategy.this.readAces((AclImpl)acl);
                if (!aces.contains(ace)) {
                    aces.add(ace);
                }
            }
        }
    }
}

