/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.http.converter.jaxb.JaxbOAuth2ExceptionMessageConverter;
import org.springframework.security.oauth2.provider.error.OAuth2ExceptionRenderer;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOAuth2ExceptionRenderer
implements OAuth2ExceptionRenderer {
    private final Log logger = LogFactory.getLog(DefaultOAuth2ExceptionRenderer.class);
    private List<HttpMessageConverter<?>> messageConverters = this.geDefaultMessageConverters();

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Override
    public void handleHttpEntityResponse(HttpEntity<?> responseEntity, ServletWebRequest webRequest) throws Exception {
        Object body;
        HttpHeaders entityHeaders;
        if (responseEntity == null) {
            return;
        }
        HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
        HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
        if (responseEntity instanceof ResponseEntity && outputMessage instanceof ServerHttpResponse) {
            ((ServerHttpResponse)outputMessage).setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
        }
        if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
            outputMessage.getHeaders().putAll((Map)entityHeaders);
        }
        if ((body = responseEntity.getBody()) != null) {
            this.writeWithMessageConverters(body, inputMessage, outputMessage);
        } else {
            outputMessage.getBody();
        }
    }

    private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        Class<?> returnValueType = returnValue.getClass();
        ArrayList allSupportedMediaTypes = new ArrayList();
        for (MediaType mediaType : acceptedMediaTypes) {
            for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                if (!messageConverter.canWrite(returnValueType, mediaType)) continue;
                messageConverter.write(returnValue, mediaType, outputMessage);
                if (this.logger.isDebugEnabled()) {
                    MediaType contentType = outputMessage.getHeaders().getContentType();
                    if (contentType == null) {
                        contentType = mediaType;
                    }
                    this.logger.debug((Object)("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]"));
                }
                return;
            }
        }
        for (HttpMessageConverter httpMessageConverter : this.messageConverters) {
            allSupportedMediaTypes.addAll(httpMessageConverter.getSupportedMediaTypes());
        }
        throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
    }

    private List<HttpMessageConverter<?>> geDefaultMessageConverters() {
        ArrayList result = new ArrayList();
        result.addAll(new RestTemplate().getMessageConverters());
        result.add((HttpMessageConverter<?>)new JaxbOAuth2ExceptionMessageConverter());
        return result;
    }

    private HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }

    private HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
        HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse();
        return new ServletServerHttpResponse(servletResponse);
    }
}

