/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.util.Assert;

class MutableCacheStatistics
implements CacheStatistics {
    private final String cacheName;
    private final Instant aliveSince;
    private Instant lastReset;
    private final LongAdder puts;
    private final LongAdder gets;
    private final LongAdder hits;
    private final LongAdder misses;
    private final LongAdder deletes;
    private final LongAdder lockWaitTimeNs;

    MutableCacheStatistics(String cacheName) {
        this.lastReset = this.aliveSince = Instant.now();
        this.puts = new LongAdder();
        this.gets = new LongAdder();
        this.hits = new LongAdder();
        this.misses = new LongAdder();
        this.deletes = new LongAdder();
        this.lockWaitTimeNs = new LongAdder();
        this.cacheName = cacheName;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public long getPuts() {
        return this.puts.sum();
    }

    void incPuts() {
        this.puts.increment();
    }

    @Override
    public long getGets() {
        return this.gets.sum();
    }

    void incGets() {
        this.gets.increment();
    }

    @Override
    public long getHits() {
        return this.hits.sum();
    }

    void incHits() {
        this.hits.increment();
    }

    @Override
    public long getMisses() {
        return this.misses.sum();
    }

    void incMisses() {
        this.misses.increment();
    }

    @Override
    public long getDeletes() {
        return this.deletes.sum();
    }

    void incDeletes(int x) {
        this.deletes.add(x);
    }

    @Override
    public long getLockWaitDuration(TimeUnit unit) {
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        return unit.convert(this.lockWaitTimeNs.sum(), TimeUnit.NANOSECONDS);
    }

    @Override
    public Instant getSince() {
        return this.aliveSince;
    }

    @Override
    public Instant getLastReset() {
        return this.lastReset;
    }

    void incLockWaitTime(long waitTimeNs) {
        this.lockWaitTimeNs.add(waitTimeNs);
    }

    void reset() {
        this.lastReset = Instant.now();
        this.puts.reset();
        this.gets.reset();
        this.hits.reset();
        this.misses.reset();
        this.deletes.reset();
        this.lockWaitTimeNs.reset();
    }

    CacheStatistics captureSnapshot() {
        return new Snapshot(this);
    }

    private static class Snapshot
    implements CacheStatistics {
        private final String cacheName;
        private final long puts;
        private final long gets;
        private final long hits;
        private final long misses;
        private final long deletes;
        private final long lockWaitTimeNS;
        private final long pending;
        private final Instant time;
        private final Instant since;
        private final Instant lastReset;

        Snapshot(CacheStatistics statistics) {
            this.cacheName = statistics.getCacheName();
            this.gets = statistics.getGets();
            this.hits = statistics.getHits();
            this.misses = statistics.getMisses();
            this.puts = statistics.getPuts();
            this.deletes = statistics.getDeletes();
            this.pending = this.gets - (this.hits + this.misses);
            this.lockWaitTimeNS = statistics.getLockWaitDuration(TimeUnit.NANOSECONDS);
            this.time = Instant.now();
            this.since = Instant.from(statistics.getSince());
            this.lastReset = Instant.from(statistics.getLastReset());
        }

        @Override
        public String getCacheName() {
            return this.cacheName;
        }

        @Override
        public long getPuts() {
            return this.puts;
        }

        @Override
        public long getGets() {
            return this.gets;
        }

        @Override
        public long getHits() {
            return this.hits;
        }

        @Override
        public long getMisses() {
            return this.misses;
        }

        @Override
        public long getPending() {
            return this.pending;
        }

        @Override
        public long getDeletes() {
            return this.deletes;
        }

        @Override
        public long getLockWaitDuration(TimeUnit unit) {
            Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
            return unit.convert(this.lockWaitTimeNS, TimeUnit.NANOSECONDS);
        }

        @Override
        public Instant getSince() {
            return this.since;
        }

        @Override
        public Instant getLastReset() {
            return this.lastReset;
        }

        @Override
        public Instant getTime() {
            return this.time;
        }
    }
}

