/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.function.Predicate;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Predicates;
import org.springframework.lang.Nullable;

public class PersistentPropertyTranslator {
    public MongoPersistentProperty translate(MongoPersistentProperty property) {
        return property;
    }

    public static PersistentPropertyTranslator create(@Nullable MongoPersistentEntity<?> targetEntity) {
        return PersistentPropertyTranslator.create(targetEntity, Predicates.isTrue());
    }

    public static PersistentPropertyTranslator create(@Nullable MongoPersistentEntity<?> targetEntity, Predicate<MongoPersistentProperty> translationFilter) {
        return targetEntity != null ? new EntityPropertyTranslator(targetEntity, translationFilter) : new PersistentPropertyTranslator();
    }

    private static class EntityPropertyTranslator
    extends PersistentPropertyTranslator {
        private final MongoPersistentEntity<?> targetEntity;
        private final Predicate<MongoPersistentProperty> translationFilter;

        EntityPropertyTranslator(MongoPersistentEntity<?> targetEntity, Predicate<MongoPersistentProperty> translationFilter) {
            this.targetEntity = targetEntity;
            this.translationFilter = translationFilter;
        }

        @Override
        public MongoPersistentProperty translate(MongoPersistentProperty property) {
            if (!this.translationFilter.test(property)) {
                return property;
            }
            MongoPersistentProperty targetProperty = (MongoPersistentProperty)this.targetEntity.getPersistentProperty(property.getName());
            return targetProperty != null ? targetProperty : property;
        }
    }
}

