/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.util.Assert;

public class GeoCommand {
    private final Shape shape;
    private final String command;

    public GeoCommand(Shape shape) {
        Assert.notNull((Object)shape, (String)"Shape must not be null!");
        this.shape = shape;
        this.command = this.getCommand(shape);
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getCommand() {
        return this.command;
    }

    private String getCommand(Shape shape) {
        Assert.notNull((Object)shape, (String)"Shape must not be null!");
        if (shape instanceof Box) {
            return "$box";
        }
        if (shape instanceof Circle || shape instanceof org.springframework.data.mongodb.core.geo.Circle) {
            return "$center";
        }
        if (shape instanceof Polygon) {
            return "$polygon";
        }
        if (shape instanceof Sphere) {
            return "$centerSphere";
        }
        throw new IllegalArgumentException("Unknown shape: " + shape);
    }
}

