/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.ExpressionMarker;
import org.springframework.data.repository.aot.generate.LocalVariableNameFactory;
import org.springframework.data.repository.aot.generate.MethodMetadata;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.data.repository.aot.generate.VariableNameFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ObjectUtils;

public class AotQueryMethodGenerationContext {
    private final Method method;
    private final MergedAnnotations annotations;
    private final QueryMethod queryMethod;
    private final RepositoryInformation repositoryInformation;
    private final AotRepositoryFragmentMetadata targetTypeMetadata;
    private final MethodReturn methodReturn;
    private final MethodMetadata targetMethodMetadata;
    private final VariableNameFactory variableNameFactory;
    private final ExpressionMarker expressionMarker;

    protected AotQueryMethodGenerationContext(RepositoryInformation repositoryInformation, Method method, QueryMethod queryMethod) {
        this.method = method;
        this.annotations = MergedAnnotations.from((AnnotatedElement)method);
        this.queryMethod = queryMethod;
        this.repositoryInformation = repositoryInformation;
        this.targetTypeMetadata = new AotRepositoryFragmentMetadata();
        this.targetMethodMetadata = new MethodMetadata(repositoryInformation, method);
        this.methodReturn = new MethodReturn(queryMethod.getResultProcessor().getReturnedType(), this.targetMethodMetadata.getReturnType());
        this.variableNameFactory = LocalVariableNameFactory.forMethod(this.targetMethodMetadata);
        this.expressionMarker = new ExpressionMarker();
    }

    AotQueryMethodGenerationContext(RepositoryInformation repositoryInformation, Method method, QueryMethod queryMethod, AotRepositoryFragmentMetadata targetTypeMetadata) {
        this.method = method;
        this.annotations = MergedAnnotations.from((AnnotatedElement)method);
        this.queryMethod = queryMethod;
        this.repositoryInformation = repositoryInformation;
        this.targetTypeMetadata = targetTypeMetadata;
        this.targetMethodMetadata = new MethodMetadata(repositoryInformation, method);
        this.methodReturn = new MethodReturn(queryMethod.getResultProcessor().getReturnedType(), this.targetMethodMetadata.getReturnType());
        this.variableNameFactory = LocalVariableNameFactory.forMethod(this.targetMethodMetadata);
        this.expressionMarker = new ExpressionMarker();
    }

    MethodMetadata getTargetMethodMetadata() {
        return this.targetMethodMetadata;
    }

    public @Nullable MethodParameter getMethodParameter(String name) {
        return this.getTargetMethodMetadata().getMethodParameters().get(name);
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public @Nullable String fieldNameOf(Class<?> type) {
        return this.targetTypeMetadata.fieldNameOf(type);
    }

    public Method getMethod() {
        return this.method;
    }

    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    public <A extends Annotation> MergedAnnotation<A> getAnnotation(Class<A> annotationType) {
        return this.annotations.get(annotationType);
    }

    public Class<?> getDomainType() {
        return this.getRepositoryInformation().getDomainType();
    }

    public MethodReturn getMethodReturn() {
        return this.methodReturn;
    }

    public ReturnedType getReturnedType() {
        return this.queryMethod.getResultProcessor().getReturnedType();
    }

    public String getRequiredBindableParameterName(int parameterIndex) {
        String name = this.getBindableParameterName(parameterIndex);
        if (ObjectUtils.isEmpty((Object)name)) {
            throw new IllegalArgumentException("No bindable parameter with index %d".formatted(parameterIndex));
        }
        return name;
    }

    public @Nullable String getBindableParameterName(int parameterIndex) {
        int bindable = 0;
        int totalIndex = 0;
        for (Parameter parameter : this.queryMethod.getParameters()) {
            if (parameter.isBindable()) {
                if (bindable == parameterIndex) {
                    return this.getParameterName(totalIndex);
                }
                ++bindable;
            }
            ++totalIndex;
        }
        return null;
    }

    public String getRequiredBindableParameterName(String parameterName) {
        String name = this.getBindableParameterName(parameterName);
        if (ObjectUtils.isEmpty((Object)name)) {
            throw new IllegalArgumentException("No bindable parameter with name '%s'".formatted(parameterName));
        }
        return name;
    }

    public @Nullable String getBindableParameterName(String parameterName) {
        int totalIndex = 0;
        for (Parameter parameter : this.queryMethod.getParameters()) {
            ++totalIndex;
            if (!parameter.isBindable() || !parameter.getName().filter(it -> it.equals(parameterName)).isPresent()) continue;
            return this.getParameterName(totalIndex - 1);
        }
        return null;
    }

    public List<String> getBindableParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            result.add(this.getParameterName(parameter.getIndex()));
        }
        return result;
    }

    public List<String> getAllParameterNames() {
        return this.targetMethodMetadata.getMethodArguments().keySet().stream().toList();
    }

    public String localVariable(String variableName) {
        return this.targetMethodMetadata.getOrCreateLocalVariable(variableName, this.variableNameFactory::generateName);
    }

    public @Nullable String getParameterName(int position) {
        return this.targetMethodMetadata.getParameterName(position);
    }

    public @Nullable String getSortParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getSortIndex());
    }

    public @Nullable String getPageableParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getPageableIndex());
    }

    public @Nullable String getLimitParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getLimitIndex());
    }

    public @Nullable String getScrollPositionParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getScrollPositionIndex());
    }

    public @Nullable String getDynamicProjectionParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getDynamicProjectionIndex());
    }

    public @Nullable String getVectorParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getVectorIndex());
    }

    public @Nullable String getScoreParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getScoreIndex());
    }

    public @Nullable String getScoreRangeParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getScoreRangeIndex());
    }

    public ExpressionMarker getExpressionMarker() {
        return this.expressionMarker;
    }
}

