/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.io.Serializable;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Score;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class SearchResult<T>
implements Serializable {
    private static final long serialVersionUID = 1637452570977581370L;
    private final T content;
    private final Score score;

    public SearchResult(T content, Score score) {
        Assert.notNull(content, (String)"Content must not be null");
        Assert.notNull((Object)score, (String)"Score must not be null");
        this.content = content;
        this.score = score;
    }

    public SearchResult(T content, double score) {
        this(content, Score.of(score));
    }

    public T getContent() {
        return this.content;
    }

    public Score getScore() {
        return this.score;
    }

    public <U> SearchResult<U> map(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null");
        return new SearchResult<U>(converter.apply(this.getContent()), this.getScore());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult result = (SearchResult)o;
        if (!ObjectUtils.nullSafeEquals(this.content, result.content)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.score, (Object)result.score);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash((Object[])new Object[]{this.content, this.score});
    }

    public String toString() {
        return String.format("SearchResult [content: %s, score: %s]", this.content, this.score);
    }
}

