/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.callback;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.comparator.Comparators;

class EntityCallbackDiscoverer {
    private final CallbackRetriever defaultRetriever = new CallbackRetriever();
    private final Map<CallbackCacheKey, CallbackRetriever> retrieverCache = new ConcurrentHashMap<CallbackCacheKey, CallbackRetriever>(64);
    private @Nullable ClassLoader beanClassLoader;

    EntityCallbackDiscoverer() {
    }

    EntityCallbackDiscoverer(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntityCallback(EntityCallback<?> callback) {
        Assert.notNull(callback, (String)"Callback must not be null");
        CallbackRetriever callbackRetriever = this.defaultRetriever;
        synchronized (callbackRetriever) {
            Object singletonTarget = AopProxyUtils.getSingletonTarget(callback);
            if (singletonTarget instanceof EntityCallback) {
                this.defaultRetriever.entityCallbacks.remove(singletonTarget);
            }
            this.defaultRetriever.entityCallbacks.add(callback);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends S, S> Collection<EntityCallback<S>> getEntityCallbacks(Class<T> entity, ResolvableType callbackType) {
        CallbackCacheKey cacheKey = new CallbackCacheKey(callbackType, entity);
        CallbackRetriever retriever = this.retrieverCache.get(cacheKey);
        if (retriever != null) {
            return retriever.getEntityCallbacks();
        }
        if (this.beanClassLoader == null || ClassUtils.isCacheSafe(entity, (ClassLoader)this.beanClassLoader) && ClassUtils.isCacheSafe(entity, (ClassLoader)this.beanClassLoader)) {
            CallbackRetriever callbackRetriever = this.defaultRetriever;
            synchronized (callbackRetriever) {
                retriever = this.retrieverCache.get(cacheKey);
                if (retriever != null) {
                    return retriever.getEntityCallbacks();
                }
                retriever = new CallbackRetriever();
                Collection<EntityCallback<S>> callbacks = this.retrieveEntityCallbacks(ResolvableType.forClass(entity), callbackType, retriever);
                this.retrieverCache.put(cacheKey, retriever);
                return callbacks;
            }
        }
        return this.retrieveEntityCallbacks(callbackType, callbackType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EntityCallback<?>> retrieveEntityCallbacks(ResolvableType entityType, ResolvableType callbackType, @Nullable CallbackRetriever retriever) {
        LinkedHashSet callbacks;
        ArrayList allCallbacks = new ArrayList();
        CallbackRetriever callbackRetriever = this.defaultRetriever;
        synchronized (callbackRetriever) {
            callbacks = new LinkedHashSet(this.defaultRetriever.entityCallbacks);
        }
        for (EntityCallback entityCallback : callbacks) {
            EntityCallback entityCallback2;
            if (!EntityCallbackDiscoverer.supportsEvent(entityCallback, entityType, callbackType)) continue;
            if (entityCallback instanceof EntityCallbackAdapter) {
                EntityCallbackAdapter adapter = (EntityCallbackAdapter)entityCallback;
                v0 = adapter.delegate();
            } else {
                v0 = entityCallback2 = entityCallback;
            }
            if (retriever != null) {
                retriever.getEntityCallbacks().add(entityCallback2);
            }
            allCallbacks.add(entityCallback2);
        }
        AnnotationAwareOrderComparator.sort(allCallbacks);
        if (retriever != null) {
            retriever.entityCallbacks.clear();
            retriever.entityCallbacks.addAll(allCallbacks);
        }
        return allCallbacks;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            if (this.beanClassLoader == null) {
                this.beanClassLoader = cbf.getBeanClassLoader();
            }
        }
        this.defaultRetriever.discoverEntityCallbacks(beanFactory);
        this.retrieverCache.clear();
    }

    static Method lookupCallbackMethod(Class<?> callbackType, Class<?> entityType, Object[] args) {
        ArrayList methods = new ArrayList(1);
        ReflectionUtils.doWithMethods(callbackType, methods::add, method -> {
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != args.length + 1 || method.isBridge() || ReflectionUtils.isObjectMethod((Method)method)) {
                return false;
            }
            return ClassUtils.isAssignable(method.getParameterTypes()[0], (Class)entityType);
        });
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        throw new IllegalStateException("%s does not define a callback method accepting %s and %s additional arguments".formatted(ClassUtils.getShortName(callbackType), ClassUtils.getShortName(entityType), args.length));
    }

    static <T> BiFunction<EntityCallback<T>, T, Object> computeCallbackInvokerFunction(EntityCallback<T> callback, Method callbackMethod, Object[] args) {
        return (entityCallback, entity) -> {
            Object[] invocationArgs = new Object[args.length + 1];
            invocationArgs[0] = entity;
            if (args.length > 0) {
                System.arraycopy(args, 0, invocationArgs, 1, args.length);
            }
            return ReflectionUtils.invokeMethod((Method)callbackMethod, (Object)callback, (Object[])invocationArgs);
        };
    }

    static boolean supportsEvent(ResolvableType callbackType, ResolvableType entityType) {
        return callbackType.as(EntityCallback.class).getGeneric(new int[]{0}).isAssignableFrom(entityType);
    }

    static boolean supportsEvent(EntityCallback<?> callback, ResolvableType entityType, ResolvableType callbackType) {
        boolean bl;
        if (callback instanceof EntityCallbackAdapter) {
            EntityCallbackAdapter provider = (EntityCallbackAdapter)callback;
            bl = provider.supports(callbackType, entityType);
        } else {
            bl = callbackType.isInstance(callback) && EntityCallbackDiscoverer.supportsEvent(ResolvableType.forInstance(callback), entityType);
        }
        return bl;
    }

    private static class CallbackRetriever {
        private final Set<EntityCallback<?>> entityCallbacks = new LinkedHashSet();

        private CallbackRetriever() {
        }

        Collection<EntityCallback<?>> getEntityCallbacks() {
            return this.entityCallbacks;
        }

        void discoverEntityCallbacks(BeanFactory beanFactory) {
            if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
                beanFactory.getBeanProvider(EntityCallback.class).stream().forEach(this.entityCallbacks::add);
                return;
            }
            ConfigurableListableBeanFactory bf = (ConfigurableListableBeanFactory)beanFactory;
            for (String beanName : bf.getBeanNamesForType(EntityCallback.class)) {
                EntityCallback bean = (EntityCallback)bf.getBean(beanName);
                ResolvableType type = ResolvableType.forClass(EntityCallback.class, bean.getClass());
                ResolvableType entityType = type.getGeneric(new int[]{0});
                if (entityType.resolve() != null) {
                    this.entityCallbacks.add(bean);
                    continue;
                }
                BeanDefinition definition = bf.getMergedBeanDefinition(beanName);
                this.entityCallbacks.add(new EntityCallbackAdapter(bean, definition.getResolvableType()));
            }
        }
    }

    private static final class CallbackCacheKey
    implements Comparable<CallbackCacheKey> {
        private static final Comparator<CallbackCacheKey> COMPARATOR = Comparators.nullsHigh().thenComparing(it -> it.callbackType.toString()).thenComparing(it -> it.entityType.getName());
        private final ResolvableType callbackType;
        private final Class<?> entityType;

        private CallbackCacheKey(ResolvableType callbackType, Class<?> entityType) {
            this.callbackType = callbackType;
            this.entityType = entityType;
        }

        @Override
        public int compareTo(@Nullable CallbackCacheKey other) {
            return COMPARATOR.compare(this, other);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CallbackCacheKey)) {
                return false;
            }
            CallbackCacheKey that = (CallbackCacheKey)obj;
            return Objects.equals(this.callbackType, that.callbackType) && Objects.equals(this.entityType, that.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.callbackType, this.entityType);
        }

        public String toString() {
            return "CallbackCacheKey[callbackType=" + String.valueOf(this.callbackType) + ", entityType=" + String.valueOf(this.entityType) + "]";
        }
    }

    private record EntityCallbackAdapter<T>(EntityCallback<T> delegate, ResolvableType type) implements EntityCallback<T>
    {
        boolean supports(ResolvableType callbackType, ResolvableType entityType) {
            return callbackType.isInstance(this.delegate) && EntityCallbackDiscoverer.supportsEvent(this.type, entityType);
        }
    }
}

