/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.Collection;
import java.util.List;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

abstract class AbstractHttpHeadersFilter
implements HttpHeadersFilter {
    static final String SPAN_ATTRIBUTE = Span.class.getName();
    final Tracer tracer;
    final HttpClientHandler handler;
    final Propagator propagator;

    AbstractHttpHeadersFilter(Tracer tracer, HttpClientHandler handler, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.handler = handler;
    }

    static final class ServerHttpClientResponse
    implements HttpClientResponse {
        final ServerHttpResponse delegate;

        ServerHttpClientResponse(ServerHttpResponse delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.getStatusCode() != null ? this.delegate.getStatusCode().value() : 0;
        }

        public String header(String header) {
            List headers = this.delegate.getHeaders().get((Object)header);
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            return (String)headers.get(0);
        }
    }

    static final class ServerHttpClientRequest
    implements HttpClientRequest {
        final ServerHttpRequest delegate;
        final HttpHeaders filteredHeaders;

        ServerHttpClientRequest(ServerHttpRequest delegate, HttpHeaders filteredHeaders) {
            this.delegate = delegate;
            this.filteredHeaders = filteredHeaders;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethodValue();
        }

        public String path() {
            return this.delegate.getURI().getPath();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            return this.filteredHeaders.getFirst(name);
        }

        public void header(String name, String value) {
            this.filteredHeaders.set(name, value);
        }
    }
}

