/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.filter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

public class FilterAnnotations
implements Iterable<TypeFilter> {
    private final ClassLoader classLoader;
    private final List<TypeFilter> filters;

    public FilterAnnotations(ClassLoader classLoader, ComponentScan.Filter[] filters) {
        Assert.notNull((Object)filters, (String)"Filters must not be null");
        this.classLoader = classLoader;
        this.filters = this.createTypeFilters(filters);
    }

    private List<TypeFilter> createTypeFilters(ComponentScan.Filter[] filters) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        for (ComponentScan.Filter filter : filters) {
            for (Class filterClass : filter.classes()) {
                typeFilters.add(this.createTypeFilter(filter.type(), filterClass));
            }
            for (String pattern : filter.pattern()) {
                typeFilters.add(this.createTypeFilter(filter.type(), pattern));
            }
        }
        return Collections.unmodifiableList(typeFilters);
    }

    private TypeFilter createTypeFilter(FilterType filterType, Class<?> filterClass) {
        switch (filterType) {
            case ANNOTATION: {
                Assert.isAssignable(Annotation.class, filterClass, (String)"An error occurred while processing an ANNOTATION type filter: ");
                return new AnnotationTypeFilter(filterClass);
            }
            case ASSIGNABLE_TYPE: {
                return new AssignableTypeFilter(filterClass);
            }
            case CUSTOM: {
                Assert.isAssignable(TypeFilter.class, filterClass, (String)"An error occurred while processing a CUSTOM type filter: ");
                return (TypeFilter)BeanUtils.instantiateClass(filterClass, TypeFilter.class);
            }
        }
        throw new IllegalArgumentException("Filter type not supported with Class value: " + filterType);
    }

    private TypeFilter createTypeFilter(FilterType filterType, String pattern) {
        return switch (filterType) {
            case FilterType.ASPECTJ -> new AspectJTypeFilter(pattern, this.classLoader);
            case FilterType.REGEX -> new RegexPatternTypeFilter(Pattern.compile(pattern));
            default -> throw new IllegalArgumentException("Filter type not supported with String pattern: " + filterType);
        };
    }

    @Override
    public Iterator<TypeFilter> iterator() {
        return this.filters.iterator();
    }

    public boolean anyMatches(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        for (TypeFilter filter : this) {
            if (!filter.match(metadataReader, metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }
}

