/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;
import reactor.netty.http.server.HttpRequestDecoderSpec;

public class NettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public NettyWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(NettyReactiveWebServerFactory factory) {
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(this.serverProperties::getMaxHttpHeaderSize).to(maxHttpRequestHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (DataSize)maxHttpRequestHeaderSize));
        propertyMapper.from(this.serverProperties::getConnectionTimeout).to(connectionTimeout -> this.customizeGenericConnectionTimeout(factory, (Duration)connectionTimeout));
        ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
        propertyMapper.from(nettyProperties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NONE)) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeMaxHttpHeaderSize(NettyReactiveWebServerFactory factory, DataSize maxHttpHeaderSize) {
        factory.addServerCustomizers(new NettyServerCustomizer[]{httpServer -> httpServer.httpRequestDecoder(httpRequestDecoderSpec -> (HttpRequestDecoderSpec)httpRequestDecoderSpec.maxHeaderSize((int)maxHttpHeaderSize.toBytes()))});
    }

    private void customizeGenericConnectionTimeout(NettyReactiveWebServerFactory factory, Duration connectionTimeout) {
        if (!connectionTimeout.isZero()) {
            long timeoutMillis = connectionTimeout.isNegative() ? 0L : connectionTimeout.toMillis();
            factory.addServerCustomizers(new NettyServerCustomizer[]{httpServer -> httpServer.tcpConfiguration(tcpServer -> tcpServer.selectorOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)timeoutMillis)))});
        }
    }

    private void customizeConnectionTimeout(NettyReactiveWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(new NettyServerCustomizer[]{httpServer -> httpServer.tcpConfiguration(tcpServer -> tcpServer.selectorOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())))});
    }
}

