/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.SessionCondition;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@Conditional(value={SessionCondition.class})
class RedisSessionConfiguration {
    RedisSessionConfiguration() {
    }

    @Configuration
    public static class SpringBootRedisHttpSessionConfiguration
    extends RedisHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties) {
            Integer timeout = sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            SessionProperties.Redis redis = sessionProperties.getRedis();
            this.setRedisNamespace(redis.getNamespace());
            this.setRedisFlushMode(redis.getFlushMode());
        }
    }
}

