/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.OnJavaCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnJavaCondition.class})
public @interface ConditionalOnJava {
    public Range range() default Range.EQUAL_OR_NEWER;

    public JavaVersion value();

    public static enum JavaVersion {
        SIX(3, "1.6"),
        SEVEN(4, "1.7"),
        EIGHT(5, "1.8"),
        NINE(6, "1.9");

        private final int value;
        private final String name;

        private JavaVersion(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public boolean isWithin(Range range, JavaVersion version) {
            Assert.notNull((Object)((Object)range), (String)"Range must not be null");
            Assert.notNull((Object)((Object)version), (String)"Version must not be null");
            switch (range) {
                case EQUAL_OR_NEWER: {
                    return this.value >= version.value;
                }
                case OLDER_THAN: {
                    return this.value < version.value;
                }
            }
            throw new IllegalStateException("Unknown range " + (Object)((Object)range));
        }

        public String toString() {
            return this.name;
        }

        public static JavaVersion getJavaVersion() {
            int version = JdkVersion.getMajorJavaVersion();
            for (JavaVersion candidate : JavaVersion.values()) {
                if (candidate.value != version) continue;
                return candidate;
            }
            return SIX;
        }
    }

    public static enum Range {
        EQUAL_OR_NEWER,
        OLDER_THAN;

    }
}

