/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.config.impl.JMSConfigurationImpl;
import org.hornetq.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.hornetq.jms.server.config.impl.TopicConfigurationImpl;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQConfigurationCustomizer;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQEmbeddedConfigurationFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQMode;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQNoOpBindingRegistry;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, HornetQJMSClient.class})
@EnableConfigurationProperties(value={HornetQProperties.class})
public class HornetQAutoConfiguration {
    private static final String EMBEDDED_JMS_CLASS = "org.hornetq.jms.server.embedded.EmbeddedJMS";
    @Autowired
    private HornetQProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory jmsConnectionFactory() {
        HornetQMode mode = this.properties.getMode();
        if (mode == null) {
            mode = this.deduceMode();
        }
        if (mode == HornetQMode.EMBEDDED) {
            return this.createEmbeddedConnectionFactory();
        }
        return this.createNativeConnectionFactory();
    }

    private HornetQMode deduceMode() {
        if (this.properties.getEmbedded().isEnabled() && ClassUtils.isPresent((String)EMBEDDED_JMS_CLASS, null)) {
            return HornetQMode.EMBEDDED;
        }
        return HornetQMode.NATIVE;
    }

    private ConnectionFactory createEmbeddedConnectionFactory() {
        try {
            TransportConfiguration transportConfiguration = new TransportConfiguration(InVMConnectorFactory.class.getName(), this.properties.getEmbedded().generateTransportParameters());
            ServerLocator serviceLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            return new HornetQConnectionFactory(serviceLocator);
        }
        catch (NoClassDefFoundError ex) {
            throw new IllegalStateException("Unable to create InVM HornetQ connection, ensure that hornet-jms-server.jar is in the classpath", ex);
        }
    }

    private ConnectionFactory createNativeConnectionFactory() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", this.properties.getHost());
        params.put("port", this.properties.getPort());
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        return HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
    }

    @Configuration
    @ConditionalOnClass(name={"org.hornetq.jms.server.embedded.EmbeddedJMS"})
    @ConditionalOnExpression(value="${spring.hornetq.embedded.enabled:true}")
    static class EmbeddedServerConfiguration {
        @Autowired
        private HornetQProperties properties;
        @Autowired(required=false)
        private List<HornetQConfigurationCustomizer> configurationCustomizers;
        @Autowired(required=false)
        private List<JMSQueueConfiguration> queuesConfiguration;
        @Autowired(required=false)
        private List<TopicConfiguration> topicsConfiguration;

        EmbeddedServerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public org.hornetq.core.config.Configuration hornetQConfiguration() {
            return new HornetQEmbeddedConfigurationFactory(this.properties).createConfiguration();
        }

        @Bean(initMethod="start", destroyMethod="stop")
        @ConditionalOnMissingBean
        public EmbeddedJMS hornetQServer(org.hornetq.core.config.Configuration configuration, JMSConfiguration jmsConfiguration) {
            EmbeddedJMS server = new EmbeddedJMS();
            this.customize(configuration);
            server.setConfiguration(configuration);
            server.setJmsConfiguration(jmsConfiguration);
            server.setRegistry((BindingRegistry)new HornetQNoOpBindingRegistry());
            return server;
        }

        private void customize(org.hornetq.core.config.Configuration configuration) {
            if (this.configurationCustomizers != null) {
                AnnotationAwareOrderComparator.sort(this.configurationCustomizers);
                for (HornetQConfigurationCustomizer customizer : this.configurationCustomizers) {
                    customizer.customize(configuration);
                }
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public JMSConfiguration hornetQJmsConfiguration() {
            JMSConfigurationImpl configuration = new JMSConfigurationImpl();
            this.addAll(configuration.getQueueConfigurations(), this.queuesConfiguration);
            this.addAll(configuration.getTopicConfigurations(), this.topicsConfiguration);
            this.addQueues((JMSConfiguration)configuration, this.properties.getEmbedded().getQueues());
            this.addTopics((JMSConfiguration)configuration, this.properties.getEmbedded().getTopics());
            return configuration;
        }

        private <T> void addAll(List<T> list, Collection<? extends T> items) {
            if (items != null) {
                list.addAll(items);
            }
        }

        private void addQueues(JMSConfiguration configuration, String[] queues) {
            boolean persistent = this.properties.getEmbedded().isPersistent();
            for (String queue : queues) {
                configuration.getQueueConfigurations().add(new JMSQueueConfigurationImpl(queue, null, persistent, new String[]{"/queue/" + queue}));
            }
        }

        private void addTopics(JMSConfiguration configuration, String[] topics) {
            for (String topic : topics) {
                configuration.getTopicConfigurations().add(new TopicConfigurationImpl(topic, new String[]{"/topic/" + topic}));
            }
        }
    }
}

