/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.util.StringUtils;

public class PostgresPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, false, this.buildLimitClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        if (StringUtils.hasText((String)this.getGroupClause())) {
            return SqlPagingQueryUtils.generateLimitGroupedSqlQuery(this, true, this.buildLimitClause(pageSize));
        }
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, true, this.buildLimitClause(pageSize));
    }

    private String buildLimitClause(int pageSize) {
        return "LIMIT " + pageSize;
    }

    @Override
    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize - 1;
        offset = offset < 0 ? 0 : offset;
        String limitClause = "LIMIT 1 OFFSET " + offset;
        return SqlPagingQueryUtils.generateLimitJumpToQuery(this, limitClause);
    }
}

