/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.annotations.RouterOperation;
import org.springdoc.core.annotations.RouterOperations;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.CloudFunctionProvider;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringCloudFunctionProvider
implements CloudFunctionProvider,
ApplicationContextAware {
    private static final RequestMethod[] supplierRequestMethods = new RequestMethod[]{RequestMethod.GET};
    private static final RequestMethod[] consumerRequestMethods = new RequestMethod[]{RequestMethod.POST};
    private static final RequestMethod[] functionRequestMethods = new RequestMethod[]{RequestMethod.GET, RequestMethod.POST};
    private static final String[] defaultMediaTypes = new String[]{"application/json", "text/plain"};
    private final Optional<FunctionCatalog> functionCatalogOptional;
    private final SpringDocConfigProperties springDocConfigProperties;
    private ApplicationContext applicationContext;
    @Value(value="${spring.cloud.function.web.path:}")
    private String prefix = "";

    public SpringCloudFunctionProvider(Optional<FunctionCatalog> functionCatalogOptional, SpringDocConfigProperties springDocConfigProperties) {
        this.functionCatalogOptional = functionCatalogOptional;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    @Override
    public List<org.springdoc.core.fn.RouterOperation> getRouterOperations(OpenAPI openAPI) {
        GenericResponseService genericResponseService = (GenericResponseService)this.applicationContext.getBean(GenericResponseService.class);
        ArrayList<org.springdoc.core.fn.RouterOperation> routerOperationList = new ArrayList<org.springdoc.core.fn.RouterOperation>();
        this.functionCatalogOptional.ifPresent(functionCatalog -> {
            Set names = functionCatalog.getNames(null);
            for (String name : names) {
                ApiResponses apiResponses;
                org.springdoc.core.fn.RouterOperation routerOperation;
                if ("functionRouter".equals(name) || !this.applicationContext.containsBean(name)) continue;
                SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(name);
                if (function.isFunction()) {
                    for (RequestMethod requestMethod : functionRequestMethods) {
                        routerOperation = this.buildRouterOperation(name, " function", requestMethod, routerOperationList);
                        this.buildRequest(openAPI, name, function, requestMethod, routerOperation);
                        apiResponses = this.buildResponses(openAPI, function, defaultMediaTypes, genericResponseService);
                        routerOperation.getOperationModel().responses(apiResponses);
                        if (StringUtils.isEmpty((CharSequence)this.prefix)) {
                            if (RequestMethod.GET.equals((Object)requestMethod)) {
                                routerOperation.setPath("/" + name + "/{" + name + "}");
                            } else {
                                routerOperation.setPath("/" + name);
                            }
                        } else if (RequestMethod.GET.equals((Object)requestMethod)) {
                            routerOperation.setPath(this.prefix + "/" + name + "/{" + name + "}");
                        } else {
                            routerOperation.setPath(this.prefix + "/" + name);
                        }
                        org.springdoc.core.fn.RouterOperation userRouterOperation = this.getRouterFunctionPaths(name, requestMethod);
                        if (userRouterOperation == null) continue;
                        this.mergeRouterOperation(routerOperation, userRouterOperation);
                    }
                    continue;
                }
                if (function.isConsumer()) {
                    for (RequestMethod requestMethod : consumerRequestMethods) {
                        routerOperation = this.buildRouterOperation(name, " consumer", requestMethod, routerOperationList);
                        this.buildRequest(openAPI, name, function, requestMethod, routerOperation);
                        apiResponses = new ApiResponses();
                        ApiResponse apiResponse = new ApiResponse();
                        apiResponse.setContent(new Content());
                        apiResponses.put((Object)String.valueOf(HttpStatus.ACCEPTED.value()), (Object)apiResponse.description(HttpStatus.ACCEPTED.getReasonPhrase()));
                        this.getRouterOperationsCommon(name, requestMethod, routerOperation, apiResponses);
                    }
                    continue;
                }
                if (!function.isSupplier()) continue;
                for (RequestMethod requestMethod : supplierRequestMethods) {
                    routerOperation = this.buildRouterOperation(name, " supplier", requestMethod, routerOperationList);
                    apiResponses = this.buildResponses(openAPI, function, new String[]{this.springDocConfigProperties.getDefaultProducesMediaType()}, genericResponseService);
                    this.getRouterOperationsCommon(name, requestMethod, routerOperation, apiResponses);
                }
            }
        });
        return routerOperationList;
    }

    private void getRouterOperationsCommon(String name, RequestMethod requestMethod, org.springdoc.core.fn.RouterOperation routerOperation, ApiResponses apiResponses) {
        routerOperation.getOperationModel().responses(apiResponses);
        if (StringUtils.isEmpty((CharSequence)this.prefix)) {
            routerOperation.setPath("/" + name);
        } else {
            routerOperation.setPath(this.prefix + "/" + name);
        }
        org.springdoc.core.fn.RouterOperation userRouterOperation = this.getRouterFunctionPaths(name, requestMethod);
        if (userRouterOperation != null) {
            this.mergeRouterOperation(routerOperation, userRouterOperation);
        }
    }

    private void buildRequest(OpenAPI openAPI, String name, SimpleFunctionRegistry.FunctionInvocationWrapper function, RequestMethod requestMethod, org.springdoc.core.fn.RouterOperation routerOperation) {
        Type paramType = function.getInputType();
        Schema schema = SpringDocAnnotationsUtils.extractSchema(openAPI.getComponents(), paramType, null, null);
        if (RequestMethod.GET.equals((Object)requestMethod)) {
            Parameter parameter = new PathParameter().name(name).schema(schema);
            routerOperation.getOperationModel().addParametersItem(parameter);
        } else {
            RequestBody requestBody = new RequestBody();
            Content content = new Content();
            for (String defaultMediaType : defaultMediaTypes) {
                content.addMediaType(defaultMediaType, new MediaType().schema(schema));
            }
            requestBody.setContent(content);
            routerOperation.getOperationModel().setRequestBody(requestBody);
        }
    }

    private org.springdoc.core.fn.RouterOperation buildRouterOperation(String name, String type, RequestMethod requestMethod, List<org.springdoc.core.fn.RouterOperation> routerOperationList) {
        Operation operation = new Operation().operationId(name + "_" + requestMethod);
        org.springdoc.core.fn.RouterOperation routerOperation = new org.springdoc.core.fn.RouterOperation();
        routerOperation.setConsumes(defaultMediaTypes);
        routerOperation.setProduces(defaultMediaTypes);
        routerOperation.setMethods(new RequestMethod[]{requestMethod});
        operation.description(name + type);
        routerOperation.setOperationModel(operation);
        routerOperationList.add(routerOperation);
        return routerOperation;
    }

    private ApiResponses buildResponses(OpenAPI openAPI, SimpleFunctionRegistry.FunctionInvocationWrapper function, String[] mediaTypes, GenericResponseService genericResponseService) {
        Type returnType = function.getOutputType();
        Content content = genericResponseService.buildContent(openAPI.getComponents(), null, mediaTypes, null, returnType);
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setContent(content);
        apiResponses.put((Object)String.valueOf(HttpStatus.OK.value()), (Object)apiResponse.description(HttpStatus.OK.getReasonPhrase()));
        return apiResponses;
    }

    protected org.springdoc.core.fn.RouterOperation getRouterFunctionPaths(String beanName, RequestMethod requestMethod) {
        RouterOperations routerOperations = (RouterOperations)this.applicationContext.findAnnotationOnBean(beanName, RouterOperations.class);
        org.springdoc.core.fn.RouterOperation routerOperationResult = null;
        if (routerOperations == null) {
            RouterOperation routerOperation2 = (RouterOperation)this.applicationContext.findAnnotationOnBean(beanName, RouterOperation.class);
            if (routerOperation2 != null) {
                routerOperationResult = new org.springdoc.core.fn.RouterOperation(routerOperation2);
            }
        } else {
            Object[] routerOperationArray = routerOperations.value();
            if (ArrayUtils.isNotEmpty((Object[])routerOperationArray)) {
                if (routerOperationArray.length == 1) {
                    routerOperationResult = new org.springdoc.core.fn.RouterOperation((RouterOperation)routerOperationArray[0]);
                } else {
                    Optional<RouterOperation> routerOperationOptional = Arrays.stream(routerOperationArray).filter(routerOperation -> Arrays.asList(routerOperation.method()).contains(requestMethod)).findAny();
                    if (routerOperationOptional.isPresent()) {
                        routerOperationResult = new org.springdoc.core.fn.RouterOperation(routerOperationOptional.get(), requestMethod);
                    }
                }
            }
        }
        return routerOperationResult;
    }

    private void mergeRouterOperation(org.springdoc.core.fn.RouterOperation routerOperation, org.springdoc.core.fn.RouterOperation userRouterOperation) {
        if (!ArrayUtils.isEmpty((Object[])userRouterOperation.getConsumes())) {
            routerOperation.setConsumes(userRouterOperation.getConsumes());
        }
        if (!ArrayUtils.isEmpty((Object[])userRouterOperation.getProduces())) {
            routerOperation.setProduces(userRouterOperation.getProduces());
        }
        if (!ArrayUtils.isEmpty((Object[])userRouterOperation.getHeaders())) {
            routerOperation.setHeaders(userRouterOperation.getHeaders());
        }
        if (!ArrayUtils.isEmpty((Object[])userRouterOperation.getMethods())) {
            routerOperation.setMethods(userRouterOperation.getMethods());
        }
        if (!CollectionUtils.isEmpty(userRouterOperation.getQueryParams())) {
            routerOperation.setQueryParams(userRouterOperation.getQueryParams());
        }
        if (!Void.class.equals(userRouterOperation.getBeanClass())) {
            routerOperation.setBeanClass(userRouterOperation.getBeanClass());
        }
        if (userRouterOperation.getOperation() != null) {
            routerOperation.setOperation(userRouterOperation.getOperation());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

