/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email.internal;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.email.internal.EmailException;
import org.simplejavamail.email.internal.EmailPopulatingBuilderImpl;
import org.simplejavamail.email.internal.InternalEmail;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.util.MiscUtil;

public final class EmailStartingBuilderImpl
implements EmailStartingBuilder {
    private boolean ignoreDefaults = false;
    private boolean ignoreOverrides = false;

    @Deprecated
    public EmailStartingBuilderImpl() {
    }

    public EmailStartingBuilder ignoringDefaults() {
        this.ignoreDefaults = true;
        return this;
    }

    public EmailStartingBuilder ignoringOverrides() {
        this.ignoreOverrides = true;
        return this;
    }

    public EmailPopulatingBuilder startingBlank() {
        return new EmailPopulatingBuilderImpl().ignoringDefaults(this.ignoreDefaults);
    }

    public EmailPopulatingBuilder replyingTo(@NotNull Email email) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull Email email) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull Email email, @NotNull String customQuotingTemplate) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, customQuotingTemplate);
    }

    public EmailPopulatingBuilder replyingTo(@NotNull Email email, @NotNull String customQuotingTemplate) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, customQuotingTemplate);
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message) {
        return this.replyingTo(message, false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        return this.replyingTo(message, false, customQuotingTemplate);
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        return this.replyingTo(message, true, customQuotingTemplate);
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message) {
        return this.replyingTo(message, true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage emailMessage, boolean repyToAll, @NotNull String htmlTemplate) {
        MimeMessage replyMessage;
        try {
            replyMessage = (MimeMessage)emailMessage.reply(repyToAll);
            replyMessage.setText("ignore");
            replyMessage.setFrom("ignore@ignore.ignore");
        }
        catch (MessagingException e) {
            throw new EmailException("was unable to parse mimemessage to produce a reply for", (Exception)((Object)e));
        }
        Email repliedTo = EmailConverter.mimeMessageToEmail(emailMessage);
        Email generatedReply = EmailConverter.mimeMessageToEmail(replyMessage);
        return this.startingBlank().withSubject(generatedReply.getSubject()).to((Collection)generatedReply.getRecipients()).withPlainText(EmailStartingBuilder.LINE_START_PATTERN.matcher((CharSequence)MiscUtil.defaultTo((Object)repliedTo.getPlainText(), (Object)"")).replaceAll("> ")).withHTMLText(String.format(htmlTemplate, MiscUtil.defaultTo((Object)repliedTo.getHTMLText(), (Object)""))).withHeaders(generatedReply.getHeaders()).withEmbeddedImages(repliedTo.getEmbeddedImages());
    }

    public EmailPopulatingBuilder forwarding(@NotNull Email email) {
        return this.forwarding(EmailConverter.emailToMimeMessage(email));
    }

    public EmailPopulatingBuilder forwarding(@NotNull MimeMessage message) {
        return ((InternalEmailPopulatingBuilder)this.startingBlank()).withForward(message).withSubject("Fwd: " + MimeMessageParser.parseSubject(message));
    }

    public EmailPopulatingBuilder copying(@NotNull MimeMessage message) {
        return this.copying(EmailConverter.mimeMessageToEmail(message));
    }

    public EmailPopulatingBuilder copying(@NotNull EmailPopulatingBuilder emailBuilder) {
        return this.copying(emailBuilder.buildEmail());
    }

    public EmailPopulatingBuilder copying(@NotNull Email email) {
        EmailPopulatingBuilder builder = new EmailPopulatingBuilderImpl().ignoringOverrides(this.ignoreDefaults).ignoringOverrides(this.ignoreOverrides);
        if (email.getId() != null) {
            builder.fixingMessageId(email.getId());
        }
        if (email.getFromRecipient() != null) {
            builder.from(email.getFromRecipient());
        }
        builder.withReplyTo(email.getReplyToRecipients());
        if (email.getBounceToRecipient() != null) {
            builder.withBounceTo(email.getBounceToRecipient());
        }
        if (email.getPlainText() != null) {
            builder.withPlainText(email.getPlainText());
        }
        if (email.getHTMLText() != null) {
            builder.withHTMLText(email.getHTMLText());
        }
        if (email.getSubject() != null) {
            builder.withSubject(email.getSubject());
        }
        builder.withRecipients((Collection)email.getRecipients());
        builder.withEmbeddedImages(email.getEmbeddedImages());
        builder.withAttachments(email.getAttachments());
        if (email.getContentTransferEncoding() != null) {
            builder.withContentTransferEncoding(email.getContentTransferEncoding());
        }
        ((InternalEmailPopulatingBuilder)builder).withHeaders(email.getHeaders(), true);
        if (email.getSentDate() != null) {
            builder.fixingSentDate(email.getSentDate());
        }
        if (email.getPkcs12ConfigForSmimeSigning() != null) {
            builder.signWithSmime(email.getPkcs12ConfigForSmimeSigning());
        }
        if (email.getX509CertificateForSmimeEncryption() != null) {
            builder.encryptWithSmime(email.getX509CertificateForSmimeEncryption());
        }
        if (email.getDkimConfig() != null) {
            builder.signWithDomainKey(email.getDkimConfig());
        }
        if (email.getDispositionNotificationTo() != null) {
            builder.withDispositionNotificationTo(email.getDispositionNotificationTo());
        }
        if (email.getReturnReceiptTo() != null) {
            builder.withReturnReceiptTo(email.getReturnReceiptTo());
        }
        if (email.getCalendarMethod() != null) {
            builder.withCalendarText(email.getCalendarMethod(), Objects.requireNonNull(email.getCalendarText(), "CalendarText"));
        }
        if (email.getEmailToForward() != null) {
            ((InternalEmailPopulatingBuilder)builder).withForward(email.getEmailToForward());
        }
        ((InternalEmailPopulatingBuilder)builder).withDecryptedAttachments(email.getDecryptedAttachments());
        if (email.getSmimeSignedEmail() != null) {
            ((InternalEmailPopulatingBuilder)builder).withSmimeSignedEmail(email.getSmimeSignedEmail());
        }
        ((InternalEmailPopulatingBuilder)builder).withOriginalSmimeDetails(email.getOriginalSmimeDetails());
        if (!(email instanceof InternalEmail)) {
            throw new AssertionError((Object)"Email is not of type InternalEmail, this should not be possible");
        }
        if (!((InternalEmail)email).wasMergedWithSmimeSignedMessage()) {
            builder.notMergingSingleSMIMESignedAttachment();
        }
        return builder;
    }
}

