/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.fieldmapper;

import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.Predicate;

public final class MapperFieldMapper<S, T, P, M extends SourceMapper<S, P> & FieldMapper<S, P>>
implements FieldMapper<S, T> {
    public final M mapper;
    public final Setter<? super T, ? super P> propertySetter;
    public final Predicate<? super S> nullChecker;
    public final int currentValueIndex;

    public MapperFieldMapper(M mapper, Setter<? super T, ? super P> propertySetter, Predicate<? super S> nullChecker, int currentValueIndex) {
        this.mapper = (SourceMapper)Asserts.requireNonNull((String)"jdbcMapper", mapper);
        this.propertySetter = (Setter)Asserts.requireNonNull((String)"propertySetter", propertySetter);
        this.nullChecker = (Predicate)Asserts.requireNonNull((String)"nullChecker", nullChecker);
        this.currentValueIndex = currentValueIndex;
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        if (this.nullChecker.test(source)) {
            return;
        }
        Object value = null;
        if (context != null) {
            value = context.getCurrentValue(this.currentValueIndex);
        }
        if (value == null) {
            value = this.mapper.map(source, context);
            if (context != null) {
                context.setCurrentValue(this.currentValueIndex, value);
            }
            this.propertySetter.set(target, value);
        } else {
            ((FieldMapper)this.mapper).mapTo(source, value, context);
        }
    }

    public String toString() {
        return "MapperFieldMapper{jdbcMapper=" + String.valueOf(this.mapper) + ", propertySetter=" + String.valueOf(this.propertySetter) + "}";
    }
}

