/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.concurrent.Lazy;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.SeleniumCdpConnection;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;

@AutoService(value={AugmenterProvider.class})
public class DevToolsProvider
implements AugmenterProvider<HasDevTools> {
    private static final Logger LOG = Logger.getLogger(DevToolsProvider.class.getName());

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getCdpUrl((Capabilities)caps) != null;
    }

    @Override
    public Class<HasDevTools> getDescribedInterface() {
        return HasDevTools.class;
    }

    @Override
    public HasDevTools getImplementation(Capabilities caps, ExecuteMethod executeMethod) {
        final Lazy<DevTools> devTools = Lazy.lazy(() -> this.establishDevToolsConnection(caps, executeMethod));
        LOG.log(Level.INFO, "WebDriver augmented with DevTools interface; connection will not be verified until first use.");
        return new HasDevTools(){

            @Override
            public Optional<DevTools> maybeGetDevTools() {
                return devTools.getIfInitialized();
            }

            @Override
            public DevTools getDevTools() {
                return (DevTools)devTools.get();
            }
        };
    }

    private DevTools establishDevToolsConnection(Capabilities caps, ExecuteMethod executeMethod) {
        Object cdpVersion = caps.getCapability("se:cdpVersion");
        String version = cdpVersion instanceof String ? (String)cdpVersion : caps.getBrowserVersion();
        CdpInfo info = new CdpVersionFinder().match(version).orElseGet(NoOpCdpInfo::new);
        return SeleniumCdpConnection.create(caps, ((RemoteExecuteMethod)executeMethod).getWrappedDriver().getClientConfig()).map(conn -> new DevTools(info::getDomains, (Connection)conn)).orElseThrow(() -> new DevToolsException("Unable to create DevTools connection"));
    }

    private @Nullable String getCdpUrl(Capabilities caps) {
        Object cdpEnabled = caps.getCapability("se:cdpEnabled");
        if (cdpEnabled != null && !Boolean.parseBoolean(cdpEnabled.toString())) {
            return null;
        }
        Object cdp = caps.getCapability("se:cdp");
        if (cdp instanceof String) {
            return (String)cdp;
        }
        Optional<URI> reportedUri = CdpEndpointFinder.getReportedUri(caps);
        return reportedUri.map(URI::toString).orElse(null);
    }
}

