/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteLogs
implements Logs {
    protected ExecuteMethod executeMethod;
    private static final String TYPE_KEY = "type";

    public RemoteLogs(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public LogEntries get(String logType) {
        String raw = (String)this.executeMethod.execute("getLogs", (Map<String, ?>)ImmutableMap.of((Object)TYPE_KEY, (Object)logType));
        Pattern pattern = Pattern.compile("\\{.*?\"\\}\n");
        Matcher matcher = pattern.matcher(raw);
        ArrayList entries = Lists.newArrayList();
        while (matcher.find()) {
            try {
                JSONObject jsonObject = new JSONObject(matcher.group());
                entries.add(new LogEntry(((Integer)jsonObject.get("level")).intValue(), ((Long)jsonObject.get("timestamp")).longValue(), (String)jsonObject.get("message")));
            }
            catch (JSONException e) {
                throw new WebDriverException("Failed to parse logs. Raw result: " + raw, (Throwable)e);
            }
        }
        return new LogEntries((List)entries);
    }
}

