/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.ProcessUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private static final Logger log = Logger.getLogger(CommandLine.class.getName());
    private static final Method JDK6_CAN_EXECUTE = CommandLine.findJdk6CanExecuteMethod();
    private final ByteArrayOutputStream inputOut = new ByteArrayOutputStream();
    private volatile String allInput;
    private Map<String, String> env = new ConcurrentHashMap<String, String>();
    private final DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
    private final Executor executor = new DefaultExecutor();
    private final org.apache.commons.exec.CommandLine cl;
    private volatile OutputStream drainTo;
    private SeleniumWatchDog executeWatchdog = new SeleniumWatchDog(-1L);

    public CommandLine(String executable, String ... args) {
        this.cl = new org.apache.commons.exec.CommandLine(CommandLine.findExecutable(executable));
        this.cl.addArguments(args, false);
    }

    public CommandLine(String[] cmdarray) {
        String executable = CommandLine.findExecutable(cmdarray[0]);
        this.cl = new org.apache.commons.exec.CommandLine(executable);
        for (int i = 1; i < cmdarray.length; ++i) {
            this.cl.addArgument(cmdarray[i], false);
        }
    }

    Map<String, String> getEnvironment() {
        return new HashMap<String, String>(this.env);
    }

    public void setEnvironmentVariables(Map<String, String> environment) {
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            this.setEnvironmentVariable(entry.getKey(), entry.getValue());
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot have a null environment variable name!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot have a null value for environment variable " + name);
        }
        this.env.put(name, value);
    }

    public void setDynamicLibraryPath(String newLibraryPath) {
        if (newLibraryPath != null) {
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), newLibraryPath);
        }
    }

    public static String getLibraryPathPropertyName() {
        switch (Platform.getCurrent()) {
            case MAC: {
                return "DYLD_LIBRARY_PATH";
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return "PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    public static String findExecutable(String named) {
        File file = new File(named);
        if (CommandLine.canExecute(file)) {
            return named;
        }
        Map<String, String> env = System.getenv();
        String pathName = "PATH";
        if (!env.containsKey("PATH")) {
            for (String key : env.keySet()) {
                if (!"path".equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        String path = env.get(pathName);
        String[] endings = new String[]{""};
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            endings = new String[]{"", ".exe", ".com", ".bat"};
        }
        for (String segment : path.split(File.pathSeparator)) {
            for (String ending : endings) {
                file = new File(segment, named + ending);
                if (!CommandLine.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public void execute() {
        try {
            OutputStream outputStream = this.getOutputStream();
            this.executeWatchdog.reset();
            this.executor.setWatchdog((ExecuteWatchdog)this.executeWatchdog);
            this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(outputStream, outputStream, (InputStream)this.getInputStream()));
            this.executor.execute(this.cl, this.getMergedEnv(), (ExecuteResultHandler)this.handler);
            this.handler.waitFor();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private OutputStream getOutputStream() {
        return this.drainTo == null ? this.inputOut : new MultioutputStream(this.inputOut, this.drainTo);
    }

    private Map<String, String> getMergedEnv() {
        HashMap newEnv = Maps.newHashMap(System.getenv());
        newEnv.putAll(this.env);
        return newEnv;
    }

    public void executeAsync() {
        try {
            OutputStream outputStream = this.getOutputStream();
            this.executeWatchdog.reset();
            this.executor.setWatchdog((ExecuteWatchdog)this.executeWatchdog);
            this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(outputStream, outputStream, (InputStream)this.getInputStream()));
            this.executor.execute(this.cl, this.getMergedEnv(), (ExecuteResultHandler)this.handler);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private ByteArrayInputStream getInputStream() {
        return this.allInput != null ? new ByteArrayInputStream(this.allInput.getBytes()) : null;
    }

    public void waitFor() {
        try {
            this.handler.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public boolean isSuccessful() {
        return 0 == this.getExitCode();
    }

    public int getExitCode() {
        if (!this.handler.hasResult()) {
            throw new IllegalStateException("Cannot get exit code before executing command line: " + this.cl);
        }
        return this.handler.getExitValue();
    }

    public String getStdOut() {
        if (!this.handler.hasResult()) {
            throw new IllegalStateException("Cannot get output before executing command line: " + this.cl);
        }
        return new String(this.inputOut.toByteArray());
    }

    public int destroy() {
        SeleniumWatchDog watchdog = this.executeWatchdog;
        watchdog.waitForProcessStarted();
        watchdog.destroyProcess();
        watchdog.waitForTerminationAfterDestroy(2, TimeUnit.SECONDS);
        if (this.handler.hasResult()) {
            return this.getExitCode();
        }
        watchdog.destroyHarder();
        watchdog.waitForTerminationAfterDestroy(1, TimeUnit.SECONDS);
        if (this.handler.hasResult()) {
            return this.getExitCode();
        }
        log.severe(String.format("Unable to kill process with PID %s", watchdog.getPID()));
        int exitCode = -1;
        this.executor.setExitValue(exitCode);
        return exitCode;
    }

    private static boolean canExecute(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        if (JDK6_CAN_EXECUTE != null) {
            try {
                return (Boolean)JDK6_CAN_EXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return true;
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public void setInput(String allInput) {
        this.allInput = allInput;
    }

    public String toString() {
        return this.cl.toString();
    }

    public void copyOutputTo(OutputStream out) {
        this.drainTo = out;
    }

    class MultioutputStream
    extends OutputStream {
        private final OutputStream mandatory;
        private final OutputStream optional;

        MultioutputStream(OutputStream mandatory, OutputStream optional) {
            this.mandatory = mandatory;
            this.optional = optional;
        }

        public void write(int b) throws IOException {
            this.mandatory.write(b);
            if (this.optional != null) {
                this.optional.write(b);
            }
        }

        public void flush() throws IOException {
            this.mandatory.flush();
            if (this.optional != null) {
                this.optional.flush();
            }
        }

        public void close() throws IOException {
            this.mandatory.close();
            if (this.optional != null) {
                this.optional.close();
            }
        }
    }

    class SeleniumWatchDog
    extends ExecuteWatchdog {
        private volatile Process process;
        private volatile boolean starting;

        SeleniumWatchDog(long timeout) {
            super(timeout);
            this.starting = true;
        }

        public synchronized void start(Process process) {
            this.process = process;
            this.starting = false;
            super.start(process);
        }

        public void reset() {
            this.starting = true;
        }

        private String getPID() {
            return this.process.toString();
        }

        private void waitForProcessStarted() {
            while (this.starting) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void waitForTerminationAfterDestroy(int duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis(duration);
            while (!CommandLine.this.handler.hasResult() && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void destroyHarder() {
            log.info("Command failed to close cleanly. Destroying forcefully (v2). " + (Object)((Object)this));
            Process ourProc = this.process;
            ProcessUtils.killProcess(ourProc);
        }
    }
}

