/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.iphone;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.TemporaryFilesystem;
import org.openqa.selenium.remote.internal.CircularOutputStream;
import org.openqa.selenium.remote.internal.SubProcess;

public class IPhoneSimulatorBinary
extends SubProcess {
    private static final Logger LOG = Logger.getLogger(IPhoneSimulatorBinary.class.getName());
    private static final String IPHONE_LOG_FILE_PROPERTY = "webdriver.iphone.logFile";
    private static final String IPHONE_SDK_PROPERTY = "webdriver.iphone.sdk";
    private static final String DEFAULT_SDK = "3.1.2";
    private static final String SDK_LOCATION_FORMAT = "/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs/iPhoneSimulator%s.sdk";
    private static final File SCRIPT_DIRECTORY = TemporaryFilesystem.createTempDir((String)"webdriver", (String)"iWebDriver");
    private final ProcessBuilder killScript;

    public IPhoneSimulatorBinary(File iWebDriverApp) throws IOException {
        super(new ProcessBuilder("/bin/bash", IPhoneSimulatorBinary.createRunScript(iWebDriverApp).getAbsolutePath()), IPhoneSimulatorBinary.createOutputStream());
        File killScriptFile = IPhoneSimulatorBinary.createKillScript(iWebDriverApp.getName());
        this.killScript = new ProcessBuilder("/bin/bash", killScriptFile.getAbsolutePath());
    }

    private static OutputStream createOutputStream() {
        String logFileString = System.getProperty(IPHONE_LOG_FILE_PROPERTY);
        File logFile = logFileString == null ? null : new File(logFileString);
        return new CircularOutputStream(logFile);
    }

    private static File createRunScript(File executable) throws IOException {
        String sdkRoot = String.format(SDK_LOCATION_FORMAT, System.getProperty(IPHONE_SDK_PROPERTY, DEFAULT_SDK));
        String exe = executable.getCanonicalFile().getAbsolutePath();
        String scriptText = "#!/bin/bash\n" + "function shutdown() {\n" + "  echo \"killing iWebDriver...\"\n" + "  /usr/bin/killall \"iWebDriver\" || :\n" + "  echo \"killing iPhone Simulator...\"\n" + "  /usr/bin/killall \"iPhone Simulator\" || :\n" + "}\n" + "shutdown\n" + String.format("export DYLD_ROOT_PATH=%s\n", sdkRoot) + String.format("export IPHONE_SIMULATOR_ROOT=%s\n", sdkRoot) + String.format("export CFFIXED_USER_HOME=%s\n", SCRIPT_DIRECTORY.getAbsolutePath()) + "trap \"shutdown\" SIGINT SIGTERM\n" + String.format("\"%s\" -RegisterForSystemEvents &\n", exe) + "iwebdriver_pid=$!\n" + "echo \"Waiting on iWebDriver (pid=$iwebdriver_pid)\"...\n" + "wait $iwebdriver_pid\n" + "echo \"Finished running iWebDriver (pid=$iwebdriver_pid)\"!\n";
        return IPhoneSimulatorBinary.writeScript(scriptText);
    }

    private static File createKillScript(String appName) throws IOException {
        String scriptText = "#!/bin/bash\n" + "echo \"killing " + appName + "...\"\n" + "/usr/bin/killall \"" + appName + "\" || :\n" + "echo \"killing iPhone Simulator...\"\n" + "/usr/bin/killall \"iPhone Simulator\" || :\n";
        return IPhoneSimulatorBinary.writeScript(scriptText);
    }

    private static File writeScript(String scriptText) throws IOException {
        File scriptFile = File.createTempFile("iWebDriver.", ".script", SCRIPT_DIRECTORY);
        LOG.fine(String.format("%s:\n----------------------------------------------\n%s\n\n", scriptFile.getAbsolutePath(), scriptText));
        FileWriter writer = new FileWriter(scriptFile);
        writer.write(scriptText);
        writer.flush();
        writer.close();
        return scriptFile.getCanonicalFile();
    }

    @VisibleForTesting
    ProcessBuilder getKillScript() {
        return this.killScript;
    }

    public void shutdown() {
        try {
            this.killScript.start().waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        super.shutdown();
    }
}

