/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.networkutils;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.networkutils.DefaultNetworkInterfaceProvider;
import org.openqa.selenium.networkutils.INetAddress;
import org.openqa.selenium.networkutils.NetworkInterface;
import org.openqa.selenium.networkutils.NetworkInterfaceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkUtils {
    private final NetworkInterfaceProvider networkInterfaceProvider;

    NetworkUtils(NetworkInterfaceProvider networkInterfaceProvider) {
        this.networkInterfaceProvider = networkInterfaceProvider;
    }

    public NetworkUtils() {
        this(new DefaultNetworkInterfaceProvider());
    }

    public String getPrivateLocalAddress() {
        List<INetAddress> addresses = this.getLocalInterfaceAddress();
        if (addresses.isEmpty()) {
            return "127.0.0.1";
        }
        return addresses.get(0).getHostAddress();
    }

    public String obtainLoopbackIp4Address() {
        INetAddress netAddress;
        NetworkInterface linuxLoopback;
        NetworkInterface networkInterface = this.getLoopBackAndIp4Only();
        if (networkInterface != null) {
            return networkInterface.getIp4LoopbackOnly().getHostName();
        }
        String ipOfIp4LoopBack = this.getIpOfLoopBackIp4();
        if (ipOfIp4LoopBack != null) {
            return ipOfIp4LoopBack;
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null && (netAddress = linuxLoopback.getIp4LoopbackOnly()) != null) {
            return netAddress.getHostAddress();
        }
        throw new WebDriverException("Unable to resolve local loopback address, please file an issue with the full message of this error:\n" + NetworkUtils.getNetWorkDiags() + "\n==== End of error message");
    }

    private INetAddress grabFirstNetworkAddress() {
        NetworkInterface firstInterface = this.networkInterfaceProvider.getNetworkInterfaces().iterator().next();
        INetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = firstInterface.getInetAddresses().iterator().next();
        }
        if (firstAddress == null) {
            throw new WebDriverException("Unable to find loopback address for localhost");
        }
        return firstAddress;
    }

    public String getIpOfLoopBackIp4() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            INetAddress netAddress = iface.getIp4LoopbackOnly();
            if (netAddress == null) continue;
            return netAddress.getHostAddress();
        }
        return null;
    }

    private NetworkInterface getLoopBackAndIp4Only() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            if (!iface.isIp4AddressBindingOnly() || !iface.isLoopBack()) continue;
            return iface;
        }
        return null;
    }

    private List<INetAddress> getLocalInterfaceAddress() {
        NetworkInterface linuxLoopback;
        ArrayList<INetAddress> localAddresses = new ArrayList<INetAddress>();
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            for (INetAddress addr : iface.getInetAddresses()) {
                if (!addr.isLoopbackAddress() || addr.isIPv6Address()) continue;
                localAddresses.add(addr);
            }
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null) {
            for (INetAddress inetAddress : linuxLoopback.getInetAddresses()) {
                if (inetAddress.isIPv6Address()) continue;
                localAddresses.add(inetAddress);
            }
        }
        if (localAddresses.isEmpty()) {
            return Collections.singletonList(this.grabFirstNetworkAddress());
        }
        return localAddresses;
    }

    public static String getNetWorkDiags() {
        StringBuilder result = new StringBuilder();
        DefaultNetworkInterfaceProvider defaultNetworkInterfaceProvider = new DefaultNetworkInterfaceProvider();
        for (NetworkInterface networkInterface : defaultNetworkInterfaceProvider.getNetworkInterfaces()) {
            NetworkUtils.dumpToConsole(result, networkInterface);
        }
        NetworkInterface byName = defaultNetworkInterfaceProvider.getLoInterface();
        if (byName != null) {
            result.append("Loopback interface LO:\n");
            NetworkUtils.dumpToConsole(result, byName);
        }
        return result.toString();
    }

    private static void dumpToConsole(StringBuilder result, NetworkInterface inNetworkInterface) {
        if (inNetworkInterface == null) {
            return;
        }
        result.append(inNetworkInterface.getName());
        result.append("\n");
        NetworkUtils.dumpAddresses(result, inNetworkInterface.getInetAddresses());
    }

    private static void dumpAddresses(StringBuilder result, Iterable<INetAddress> inetAddresses) {
        for (INetAddress address : inetAddresses) {
            result.append("   address.getHostName() = ");
            result.append(address.getHostName());
            result.append("\n");
            result.append("   address.getHostAddress() = ");
            result.append(address.getHostAddress());
            result.append("\n");
            result.append("   address.isLoopbackAddress() = ");
            result.append(address.isLoopbackAddress());
            result.append("\n");
        }
    }

    public static void main(String[] args) throws SocketException {
        System.out.println(NetworkUtils.getNetWorkDiags());
    }
}

