/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.browserlaunchers.DoNotUseProxyPac;

public class Proxies {
    public static File makeProxyPAC(File parentDir, int port, Capabilities capabilities) throws FileNotFoundException {
        return Proxies.makeProxyPAC(parentDir, port, System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("http.nonProxyHosts"), capabilities);
    }

    public static File makeProxyPAC(File parentDir, int port, String configuredProxy, String proxyPort, String nonProxyHosts, Capabilities capabilities) throws FileNotFoundException {
        DoNotUseProxyPac pac = Proxies.newProxyPac(port, configuredProxy, proxyPort, nonProxyHosts, capabilities);
        Proxy proxy = Proxies.extractProxy(capabilities);
        if (proxy != null && proxy.getHttpProxy() != null) {
            pac.defaults().toProxy(proxy.getHttpProxy());
        }
        try {
            File pacFile = new File(parentDir, "proxy.pac");
            FileWriter out = new FileWriter(pacFile);
            pac.outputTo(out);
            ((Writer)out).close();
            return pacFile;
        }
        catch (IOException e) {
            throw new SeleniumException("Unable to configure proxy. Selenium will not work.");
        }
    }

    public static Proxy extractProxy(Capabilities capabilities) {
        Object rawProxy = capabilities.getCapability("proxy");
        Proxy proxy = null;
        if (rawProxy != null) {
            if (rawProxy instanceof Proxy) {
                proxy = (Proxy)rawProxy;
            } else if (rawProxy instanceof Map) {
                proxy = new Proxy((Map)rawProxy);
            }
        }
        return proxy;
    }

    static DoNotUseProxyPac newProxyPac(int port, String configuredProxy, String proxyPort, String nonProxyHosts, Capabilities capabilities) {
        Proxy proxy;
        DoNotUseProxyPac existingConfig = (DoNotUseProxyPac)capabilities.getCapability("proxy_pac");
        DoNotUseProxyPac pac = existingConfig == null ? new DoNotUseProxyPac() : existingConfig;
        Object tempProxy = capabilities.getCapability("proxy");
        if (tempProxy != null && (proxy = Proxies.extractProxy(capabilities)).getHttpProxy() != null) {
            pac.defaults().toProxy(proxy.getHttpProxy());
        }
        if (configuredProxy != null) {
            String proxyToUse = configuredProxy;
            if (proxyPort != null) {
                proxyToUse = proxyToUse + ":" + proxyPort;
            }
            pac.defaults().toProxy(proxyToUse);
        }
        String defaultProxy = "DIRECT";
        if (configuredProxy != null) {
            defaultProxy = "PROXY " + configuredProxy;
            if (proxyPort != null) {
                defaultProxy = defaultProxy + ":" + proxyPort;
            }
        }
        String seleniumServerAsProxy = "localhost:" + port + "; " + defaultProxy;
        if (Proxies.isOnlyProxyingSelenium(capabilities)) {
            pac.map("*/selenium-server/*").toProxy(seleniumServerAsProxy);
            if (nonProxyHosts != null && nonProxyHosts.trim().length() > 0) {
                String[] hosts;
                for (String host : hosts = nonProxyHosts.split("\\|")) {
                    pac.mapHost(host).toNoProxy();
                }
            }
        } else {
            pac.defaults().toProxy(seleniumServerAsProxy);
        }
        return pac;
    }

    public static boolean isProxyingAllTraffic(Capabilities capabilities) {
        return !capabilities.is("onlyProxySeleniumTraffic") || !capabilities.is("avoidProxy") || capabilities.is("proxyEverything");
    }

    public static boolean isOnlyProxyingSelenium(Capabilities capabilities) {
        return !Proxies.isProxyingAllTraffic(capabilities);
    }
}

