/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidDriver
extends RemoteWebDriver
implements TakesScreenshot,
Rotatable,
BrowserConnection {
    public AndroidDriver() {
        this(AndroidDriver.getDefaultUrl());
    }

    public AndroidDriver(String remoteAddress) throws MalformedURLException {
        this(new URL(remoteAddress));
    }

    public AndroidDriver(URL remoteAddress) {
        super(remoteAddress, (Capabilities)AndroidDriver.getAndroidCapabilities(null));
    }

    public AndroidDriver(URL url, DesiredCapabilities caps) {
        super(url, (Capabilities)AndroidDriver.getAndroidCapabilities(caps));
    }

    public AndroidDriver(DesiredCapabilities caps) {
        this(AndroidDriver.getDefaultUrl(), caps);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64Png = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64Png);
    }

    public boolean isOnline() {
        return (Boolean)this.execute("isBrowserOnline").getValue();
    }

    public void setOnline(boolean online) throws WebDriverException {
        this.execute("setBrowserOnline", (Map)ImmutableMap.of((Object)"state", (Object)online));
    }

    private static DesiredCapabilities getAndroidCapabilities(DesiredCapabilities userPrefs) {
        DesiredCapabilities caps = DesiredCapabilities.android();
        caps.setCapability("takesScreenshot", true);
        caps.setCapability("rotatable", true);
        caps.setCapability("browserConnectionEnabled", true);
        if (userPrefs != null) {
            caps.merge((Capabilities)userPrefs);
        }
        return caps;
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation));
    }

    public ScreenOrientation getOrientation() {
        return ScreenOrientation.valueOf((String)((String)this.execute("getScreenOrientation").getValue()));
    }

    private static URL getDefaultUrl() {
        try {
            return new URL("http://localhost:8080/wd/hub");
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Malformed default remote URL: " + e.getMessage());
        }
    }
}

