/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.android.library.AndroidAtoms;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.html5.SessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidSessionStorage
implements SessionStorage {
    private final AndroidWebDriver driver;

    public AndroidSessionStorage(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public String getItem(String key) {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_SESSION_STORAGE_ITEM.getValue(), key);
    }

    public Set<String> keySet() {
        return new HashSet<String>((Collection)this.driver.executeAtom(AndroidAtoms.GET_SESSION_STORAGE_KEYS.getValue(), new Object[0]));
    }

    public void setItem(String key, String value) {
        this.driver.executeAtom(AndroidAtoms.SET_SESSION_STORAGE_ITEM.getValue(), key, value);
    }

    public String removeItem(String key) {
        return (String)this.driver.executeAtom(AndroidAtoms.REMOVE_SESSION_STORAGE_ITEM.getValue(), key);
    }

    public void clear() {
        this.driver.executeAtom(AndroidAtoms.CLEAR_SESSION_STORAGE.getValue(), new Object[0]);
    }

    public int size() {
        return ((Long)this.driver.executeAtom(AndroidAtoms.GET_SESSION_STORAGE_SIZE.getValue(), new Object[0])).intValue();
    }
}

