/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.behavior.ClientValidatorBehavior;
import org.richfaces.component.behavior.ConverterNotFoundException;
import org.richfaces.javascript.ClientScriptService;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.javascript.ScriptNotFoundException;
import org.richfaces.renderkit.html.AjaxOnlyScript;
import org.richfaces.renderkit.html.ClientAndAjaxScript;
import org.richfaces.renderkit.html.ClientOnlyScript;
import org.richfaces.renderkit.html.ComponentValidatorScript;
import org.richfaces.renderkit.html.LibraryScriptFunction;
import org.richfaces.renderkit.html.ValidatorScriptBase;
import org.richfaces.validator.ConverterDescriptor;
import org.richfaces.validator.FacesObjectDescriptor;
import org.richfaces.validator.ValidatorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientValidatorRenderer
extends ClientBehaviorRenderer {
    public static final String RENDERER_TYPE = "org.richfaces.ClientValidatorRenderer";
    public static final String VALUE_VAR = "value";
    public static final String CONVERTED_VALUE_VAR = "convertedValue";
    public static final JSReference VALUE_LITERAL = new JSReference("value");
    public static final JSReference CONVERTED_VALUE_LITERAL = new JSReference("convertedValue");

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        if (null == behaviorContext) {
            throw new NullPointerException();
        }
        if (null == behavior) {
            throw new NullPointerException();
        }
        if (behavior instanceof ClientValidatorBehavior) {
            ClientValidatorBehavior clientValidator = (ClientValidatorBehavior)behavior;
            return this.buildAndStoreValidatorScript(behaviorContext, clientValidator);
        }
        throw new FacesException("ClientBehavior for ClientValidatorRenderer does not implement ClientValidatorBehavior interface");
    }

    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof ClientValidatorBehavior)) {
            throw new IllegalArgumentException("Instance of org.ruchvaces.component.behaviot.ClientValidatorBehavior required: " + behavior);
        }
        ClientValidatorBehavior ajaxBehavior = (ClientValidatorBehavior)behavior;
        if (!ajaxBehavior.isDisabled()) {
            component.queueEvent((FacesEvent)ClientValidatorRenderer.createEvent(component, ajaxBehavior));
        }
    }

    private static AjaxBehaviorEvent createEvent(UIComponent component, ClientValidatorBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)ajaxBehavior);
        PhaseId phaseId = ClientValidatorRenderer.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.PROCESS_VALIDATIONS;
        event.setPhaseId(phaseId);
        return event;
    }

    private static boolean isImmediate(UIComponent component, ClientValidatorBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)component).isImmediate();
        }
        return immediate;
    }

    String buildAndStoreValidatorScript(ClientBehaviorContext behaviorContext, ClientValidatorBehavior behavior) {
        ComponentValidatorScript validatorScript = this.createValidatorScript(behaviorContext, behavior);
        if (null != validatorScript) {
            FacesContext facesContext = behaviorContext.getFacesContext();
            JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
            validatorScript = (ComponentValidatorScript)javaScriptService.addScript(facesContext, (Object)validatorScript);
            return validatorScript.createCallScript(behaviorContext.getComponent().getClientId(facesContext), behaviorContext.getSourceId());
        }
        return null;
    }

    ComponentValidatorScript createValidatorScript(ClientBehaviorContext behaviorContext, ClientValidatorBehavior behavior) {
        Collection<ValidatorDescriptor> validators = behavior.getValidators(behaviorContext);
        if (!validators.isEmpty()) {
            ValidatorScriptBase validatorScript;
            try {
                ConverterDescriptor converter = behavior.getConverter(behaviorContext);
                if (null != converter) {
                    try {
                        LibraryScriptFunction clientSideConverterScript = this.getClientSideConverterScript(behaviorContext.getFacesContext(), converter);
                        validatorScript = this.createValidatorScript(behaviorContext, behavior, validators, clientSideConverterScript);
                    }
                    catch (ScriptNotFoundException e) {
                        validatorScript = new AjaxOnlyScript(this.createAjaxScript(behaviorContext, behavior));
                    }
                } else {
                    validatorScript = this.createValidatorScript(behaviorContext, behavior, validators, null);
                }
            }
            catch (ConverterNotFoundException e) {
                throw new FacesException((Throwable)e);
            }
            String clientId = this.getComponentClientId(behaviorContext);
            String name = ScriptUtils.getValidJavascriptName((String)(clientId + ":v"));
            validatorScript.setName(name);
            return validatorScript;
        }
        return null;
    }

    private String getComponentClientId(ClientBehaviorContext behaviorContext) {
        return behaviorContext.getComponent().getClientId(behaviorContext.getFacesContext());
    }

    private ValidatorScriptBase createValidatorScript(ClientBehaviorContext behaviorContext, ClientValidatorBehavior behavior, Collection<ValidatorDescriptor> validators, LibraryScriptFunction clientSideConverterScript) {
        Collection<? extends LibraryScriptFunction> validatorScripts = this.getClientSideValidatorScript(behaviorContext.getFacesContext(), validators);
        if (validatorScripts.isEmpty()) {
            return new AjaxOnlyScript(this.createAjaxScript(behaviorContext, behavior));
        }
        if (validatorScripts.size() < validators.size()) {
            return new ClientAndAjaxScript(clientSideConverterScript, validatorScripts, this.createAjaxScript(behaviorContext, behavior));
        }
        return new ClientOnlyScript(clientSideConverterScript, validatorScripts);
    }

    private String createAjaxScript(ClientBehaviorContext behaviorContext, ClientValidatorBehavior behavior) {
        String ajaxScript = behavior.getAjaxScript(behaviorContext);
        String clientId = this.getComponentClientId(behaviorContext);
        ajaxScript = this.replaceTextToVariable(ajaxScript, clientId, "id");
        String sourceId = behaviorContext.getSourceId();
        if (null != sourceId) {
            ajaxScript = this.replaceTextToVariable(ajaxScript, sourceId, "e");
        }
        return ajaxScript;
    }

    private String replaceTextToVariable(String ajaxScript, String clientId, String variableName) {
        ajaxScript = ajaxScript.replace("'" + clientId + "'", variableName);
        ajaxScript = ajaxScript.replace("\"" + clientId + "\"", variableName);
        return ajaxScript;
    }

    LibraryScriptFunction getClientSideConverterScript(FacesContext facesContext, ConverterDescriptor converter) throws ScriptNotFoundException {
        ClientScriptService clientScriptService = (ClientScriptService)ServiceTracker.getService((FacesContext)facesContext, ClientScriptService.class);
        return this.createClientFunction(facesContext, (FacesObjectDescriptor)converter, clientScriptService);
    }

    private LibraryScriptFunction createClientFunction(FacesContext facesContext, FacesObjectDescriptor descriptor, ClientScriptService clientScriptService) throws ScriptNotFoundException {
        LibraryFunction script = clientScriptService.getScript(facesContext, descriptor.getImplementationClass());
        return new LibraryScriptFunction(script, descriptor.getMessage(), descriptor.getAdditionalParameters());
    }

    Collection<? extends LibraryScriptFunction> getClientSideValidatorScript(FacesContext facesContext, Collection<ValidatorDescriptor> validators) {
        ClientScriptService clientScriptService = (ClientScriptService)ServiceTracker.getService((FacesContext)facesContext, ClientScriptService.class);
        ArrayList scripts = Lists.newArrayList();
        for (ValidatorDescriptor validator : validators) {
            try {
                scripts.add(this.createClientFunction(facesContext, (FacesObjectDescriptor)validator, clientScriptService));
            }
            catch (ScriptNotFoundException e) {}
        }
        return scripts;
    }
}

