/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.event.SelectedItemChangeEvent;
import org.richfaces.event.SelectedItemChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectedItemChangeListenerHandler
extends TagHandler
implements EditableValueHolderAttachedObjectHandler {
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public SelectedItemChangeListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (type.isLiteral()) {
                try {
                    SelectedItemChangeListenerHandler.forName(type.getValue());
                }
                catch (ClassNotFoundException e) {
                    throw new TagAttributeException(type, "Couldn't qualify SelectedItemChangeListener", (Throwable)e);
                }
            } else {
                throw new TagAttributeException(type, "Must be a literal class name of type SelectedItemChangeListener");
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof AbstractTogglePanel) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (parent.getAttributes().containsKey("javax.faces.application.Resource.ComponentResource")) {
            SelectedItemChangeListenerHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type EditableValueHolder, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        ValueExpression b = null;
        if (this.binding != null) {
            FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
            b = this.binding.getValueExpression(ctx, SelectedItemChangeListener.class);
        }
        AbstractTogglePanel evh = (AbstractTogglePanel)parent;
        evh.addSelectedItemChangeListener(new LazySelectedItemChangeListener(this.listenerType, b));
    }

    public String getFor() {
        TagAttribute attr = this.getAttribute("for");
        return attr == null ? null : attr.getValue();
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return SelectedItemChangeListenerHandler.getAttachedObjectHandlers(component, true);
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get("javax.faces.RetargetableHandlers");
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attrs.put("javax.faces.RetargetableHandlers", result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }

    public static Class forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = SelectedItemChangeListenerHandler.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, false, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    private static class LazySelectedItemChangeListener
    implements SelectedItemChangeListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final ValueExpression binding;

        LazySelectedItemChangeListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processSelectedItemChange(SelectedItemChangeEvent event) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            SelectedItemChangeListener instance = null;
            if (this.binding != null) {
                instance = (SelectedItemChangeListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (SelectedItemChangeListener)SelectedItemChangeListenerHandler.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate SelectedItemChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processSelectedItemChange(event);
            }
        }
    }
}

