/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.renderkit.SortingFilteringRowsRenderer;

public abstract class SelectionRenderer
extends SortingFilteringRowsRenderer {
    protected void encodeSelectionInput(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":si"), null);
        writer.writeAttribute("name", (Object)(component.getClientId(context) + ":si"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        UIDataTableBase table = (UIDataTableBase)component;
        StringBuilder builder = new StringBuilder("|");
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        SequenceRange range = (SequenceRange)table.getComponentState().getRange();
        int first = range.getFirstRow();
        int last = first + range.getRows() - 1;
        Map attributes = component.getAttributes();
        table.setRowKey(attributes.get("activeRowKey"));
        int activeIndex = table.getRowIndex();
        if (activeIndex > 0) {
            if (activeIndex < first) {
                builder.append("u");
            } else if (activeIndex > last) {
                builder.append("d");
            }
        }
        builder.append("|");
        table.setRowKey(attributes.get("shiftRowKey"));
        int shiftIndex = table.getRowIndex();
        if (shiftIndex > 0) {
            if (shiftIndex < first) {
                builder.append("u");
            } else if (shiftIndex > last) {
                builder.append("d");
            }
        }
        builder.append("|");
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
        writer.writeAttribute("value", (Object)builder.toString(), null);
        writer.endElement("input");
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        Map map = context.getExternalContext().getRequestParameterMap();
        String selectionString = (String)map.get(component.getClientId(context) + ":si");
        if (selectionString != null && selectionString.length() > 0) {
            final ClientSelection clientSelection = new ClientSelection(selectionString);
            final Map attributes = component.getAttributes();
            UIDataTableBase table = (UIDataTableBase)component;
            Collection<Object> selection = table.getSelection();
            if (selection == null) {
                selection = new HashSet<Object>();
                this.updateAttribute(context, component, "selection", selection);
            }
            final Collection<Object> rowKeys = selection;
            String selectionFlag = clientSelection.getSelectionFlag();
            if (selectionFlag != null) {
                selection.clear();
                if (!"x".equals(selectionFlag)) {
                    this.encodeSelectionOutsideCurrentRange(context, table, selectionFlag);
                }
            }
            if (clientSelection.isCleanShiftIndex()) {
                attributes.remove("shiftRowKey");
            }
            table.walk(context, new DataVisitor(){

                public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                    int index = clientSelection.nextIndex();
                    if (clientSelection.isSelected(index)) {
                        rowKeys.add(rowKey);
                    } else {
                        rowKeys.remove(rowKey);
                    }
                    if (clientSelection.isActiveIndex(index)) {
                        attributes.put("activeRowKey", rowKey);
                    }
                    if (clientSelection.isShiftIndex(index)) {
                        attributes.put("shiftRowKey", rowKey);
                    }
                    return DataVisitResult.CONTINUE;
                }
            }, null);
        }
    }

    private void encodeSelectionOutsideCurrentRange(FacesContext context, UIDataTableBase table, String selectionFlag) {
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        SequenceRange range = (SequenceRange)table.getComponentState().getRange();
        SequenceRange newRange = null;
        Map attributes = table.getAttributes();
        Object rowKey = attributes.get("shiftRowKey");
        if (rowKey == null) {
            rowKey = attributes.get("activeRowKey");
            attributes.put("shiftRowKey", rowKey);
        }
        table.setRowKey(rowKey);
        int shiftIndex = table.getRowIndex();
        if ("a".equals(selectionFlag)) {
            newRange = new SequenceRange(0, 0);
        } else if (shiftIndex > 0) {
            if ("u".equals(selectionFlag)) {
                newRange = new SequenceRange(shiftIndex, range.getFirstRow() - shiftIndex);
            } else {
                int last = range.getFirstRow() + range.getRows();
                newRange = new SequenceRange(last, shiftIndex - last + 1);
            }
        }
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
        if (newRange != null) {
            final Collection<Object> rowKeys = table.getSelection();
            table.walk(context, new DataVisitor(){

                public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                    rowKeys.add(rowKey);
                    return DataVisitResult.CONTINUE;
                }
            }, (Range)newRange, null);
        }
    }

    private class ClientSelection {
        public static final String FLAG_RESET = "x";
        public static final String FLAG_ALL = "a";
        public static final String FLAG_AFTER_RANGE = "d";
        public static final String FLAG_BEFORE_RANGE = "u";
        private int[][] ranges;
        private int activeIndex;
        private int shiftIndex;
        private String selectionFlag;
        private int index;

        public ClientSelection(String selectionString) {
            String[] strings = selectionString.split("\\|", -1);
            String[] rangeStrings = strings[0].split(";");
            if (strings[0].length() > 0) {
                this.ranges = new int[rangeStrings.length][2];
                for (int i = 0; i < rangeStrings.length; ++i) {
                    String[] rangeString = rangeStrings[i].split(",");
                    this.ranges[i][0] = Integer.parseInt(rangeString[0]);
                    this.ranges[i][1] = Integer.parseInt(rangeString[1]);
                }
            } else {
                this.ranges = new int[0][0];
            }
            this.activeIndex = strings[1].matches("\\d+") ? Integer.parseInt(strings[1]) : -1;
            this.shiftIndex = strings[2].matches("\\d+") ? Integer.parseInt(strings[2]) : (strings[2].length() > 0 ? -1 : -2);
            if (strings[3].length() > 0) {
                this.selectionFlag = strings[3];
            }
            this.index = 0;
        }

        public boolean isSelected(int index) {
            for (int i = 0; i < this.ranges.length && index >= this.ranges[i][0]; ++i) {
                if (index < this.ranges[i][0] || index > this.ranges[i][1]) continue;
                return true;
            }
            return false;
        }

        public boolean isActiveIndex(int index) {
            return this.activeIndex == index;
        }

        public boolean isShiftIndex(int index) {
            return this.shiftIndex == index;
        }

        public boolean isCleanShiftIndex() {
            return this.shiftIndex == -2;
        }

        public String getSelectionFlag() {
            return this.selectionFlag;
        }

        public int nextIndex() {
            return this.index++;
        }
    }
}

