/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.component.UISubTable;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.AbstractTableRenderer;
import org.richfaces.renderkit.EncodeStrategy;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="datatable.js"), @ResourceDependency(name="datatable.ecss")})
public class DataTableRenderer
extends AbstractTableRenderer {
    @Override
    public void encodeTableStructure(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        if (dataTable instanceof UIDataTable) {
            this.encodeCaption(writer, context, (UIDataTable)dataTable);
            writer.startElement("colgroup", (UIComponent)dataTable);
            int columns = this.getColumnsCount(dataTable);
            writer.writeAttribute("span", (Object)String.valueOf(columns), null);
            String columnsWidth = (String)dataTable.getAttributes().get("columnsWidth");
            if (columnsWidth != null) {
                String[] widths = columnsWidth.split(",");
                for (int i = 0; i < widths.length; ++i) {
                    writer.startElement("col", (UIComponent)dataTable);
                    writer.writeAttribute("width", (Object)widths[i], null);
                    writer.endElement("col");
                }
            }
            writer.endElement("colgroup");
        }
    }

    @Override
    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        if (encodeParentTBody) {
            if (partialUpdate) {
                this.partialStart(facesContext, dataTableBase.getClientId(facesContext) + ":tb");
            }
            this.encodeTableBodyStart(writer, facesContext, dataTableBase);
        }
    }

    @Override
    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        if (encodeParentTBody) {
            this.encodeTableBodyEnd(writer);
            if (partialUpdate) {
                this.partialEnd(facesContext);
            }
        }
    }

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        boolean parentTbodyStart;
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        UIDataTable dataTable = (UIDataTable)row;
        boolean partialUpdate = rowHolder.isUpdatePartial();
        boolean tbodyStart = parentTbodyStart = rowHolder.isEncodeParentTBody();
        rowHolder.setRowStart(true);
        Iterator components = row.columns();
        while (components.hasNext()) {
            UIComponent child = (UIComponent)components.next();
            if (child instanceof Row) {
                boolean isSubtable = child instanceof UISubTable;
                if (rowHolder.getProcessCell() != 0) {
                    this.encodeRowEnd(writer);
                    if (isSubtable) {
                        this.encodeTableBodyEnd(writer);
                        tbodyStart = false;
                        if (partialUpdate) {
                            this.partialEnd(facesContext);
                        }
                    }
                }
                rowHolder.nextCell();
                if (isSubtable && partialUpdate) {
                    String id = dataTable.getRelativeClientId(facesContext) + ":" + child.getId() + ":c";
                    this.partialStart(facesContext, id);
                }
                child.encodeAll(facesContext);
                if (!isSubtable || !partialUpdate) continue;
                this.partialEnd(facesContext);
                continue;
            }
            if (!(child instanceof UIColumn)) continue;
            if (!parentTbodyStart && !tbodyStart) {
                if (partialUpdate) {
                    this.partialStart(facesContext, dataTable.getRelativeClientId(facesContext) + ":tb");
                }
                this.encodeTableBodyStart(writer, facesContext, dataTable);
                rowHolder.setRowStart(true);
                tbodyStart = true;
            }
            this.encodeColumn(facesContext, writer, (UIColumn)child, rowHolder);
            if (components.hasNext()) continue;
            this.encodeRowEnd(writer);
            if (parentTbodyStart || !tbodyStart) continue;
            this.encodeTableBodyEnd(writer);
            tbodyStart = false;
            if (!partialUpdate) continue;
            this.partialEnd(facesContext);
        }
    }

    @Override
    public boolean encodeParentTBody(UIDataTableBase dataTableBase) {
        Iterator<UIComponent> iterator = dataTableBase.columns();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Row)) continue;
            return false;
        }
        return true;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDataTableBase dataTable = (UIDataTableBase)component;
        this.encodeTableStart(writer, context, dataTable);
        this.encodeTableFacets(writer, context, dataTable);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeTableEnd(writer);
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIDataTable.class;
    }

    public void encodeCaption(ResponseWriter writer, FacesContext context, UIDataTable dataTable) throws IOException {
        UIComponent caption = dataTable.getCaption();
        if (caption == null) {
            return;
        }
        if (!caption.isRendered()) {
            return;
        }
        writer.startElement("caption", (UIComponent)dataTable);
        String captionClass = (String)dataTable.getAttributes().get("captionClass");
        String captionSkinClass = this.getCaptionSkinClass();
        captionClass = HtmlUtil.concatClasses((String[])new String[]{captionClass, captionSkinClass});
        writer.writeAttribute("class", (Object)captionClass, "captionClass");
        String captionStyle = (String)dataTable.getAttributes().get("captionStyle");
        if (captionStyle != null && captionStyle.trim().length() != 0) {
            writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        writer.endElement("caption");
    }

    @Override
    public EncodeStrategy getHeaderEncodeStrategy(UIComponent column, String facetName) {
        return column instanceof org.richfaces.component.UIColumn && "header".equals(facetName) ? new RichHeaderEncodeStrategy() : new AbstractTableRenderer.SimpleHeaderEncodeStrategy();
    }

    @Override
    public boolean containsThead() {
        return true;
    }

    public boolean isSortable(UIColumn column) {
        if (column instanceof org.richfaces.component.UIColumn) {
            return ((org.richfaces.component.UIColumn)column).getValueExpression("sortBy") != null;
        }
        return false;
    }

    @Override
    public void encodeClientScript(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        UIDataTable dataTable = (UIDataTable)dataTableBase;
        writer.startElement("script", (UIComponent)dataTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSFunction function = new JSFunction("new RichFaces.ui.DataTable", new Object[0]);
        function.addParameter((Object)dataTable.getClientId(facesContext));
        AjaxEventOptions ajaxEventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)facesContext, (UIComponent)dataTable);
        HashMap<String, Map> options = new HashMap<String, Map>();
        options.put("ajaxEventOptions", ajaxEventOptions.getParameters());
        function.addParameter(options);
        writer.writeText((Object)function.toScript(), null);
        writer.endElement("script");
    }

    @Override
    public void encodeHiddenInput(ResponseWriter writer, FacesContext context, UIDataTableBase component) throws IOException {
    }

    @Override
    public String getTableSkinClass() {
        return "rf-dt";
    }

    public String getCaptionSkinClass() {
        return "rf-dt-cap";
    }

    @Override
    public String getRowSkinClass() {
        return "rf-dt-r";
    }

    @Override
    public String getFirstRowSkinClass() {
        return "rf-dt-f-r";
    }

    @Override
    public String getCellSkinClass() {
        return "rf-dt-c";
    }

    @Override
    public String getHeaderSkinClass() {
        return "rf-dt-h";
    }

    @Override
    public String getHeaderFirstSkinClass() {
        return "rf-dt-h-f";
    }

    @Override
    public String getHeaderCellSkinClass() {
        return "rf-dt-h-c";
    }

    @Override
    public String getColumnHeaderSkinClass() {
        return "rf-dt-sh";
    }

    @Override
    public String getColumnHeaderFirstSkinClass() {
        return "rf-dt-sh-f";
    }

    @Override
    public String getColumnHeaderCellSkinClass() {
        return "rf-dt-sh-c";
    }

    @Override
    public String getColumnFooterSkinClass() {
        return "rf-dt-sf";
    }

    @Override
    public String getColumnFooterFirstSkinClass() {
        return "rf-dt-sf-f";
    }

    @Override
    public String getColumnFooterCellSkinClass() {
        return "rf-dt-sf-c";
    }

    @Override
    public String getFooterSkinClass() {
        return "rf-dt-f";
    }

    @Override
    public String getFooterFirstSkinClass() {
        return "rf-dt-f-f";
    }

    @Override
    public String getFooterCellSkinClass() {
        return "rf-dt-f-c";
    }

    @Override
    public String getNoDataClass() {
        return "rf-dt-nd-c";
    }

    @Override
    protected void setupTableStartElement(FacesContext context, UIComponent component) {
        this.setupTableStartElement(context, component, "th");
    }

    @Override
    public EncodeStrategy getHiddenContainerStrategy(UIDataTableBase dataTableBase) {
        return new DataTableHiddenEncodeStrategy();
    }

    private class RichHeaderEncodeStrategy
    implements EncodeStrategy {
        private RichHeaderEncodeStrategy() {
        }

        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)component;
            writer.writeAttribute("id", (Object)column.getClientId(context), null);
            if (DataTableRenderer.this.isSortable(column)) {
                writer.startElement("span", (UIComponent)column);
                writer.writeAttribute("class", (Object)"rich-table-sortable-header", null);
            }
        }

        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)component;
            if (DataTableRenderer.this.isSortable(column)) {
                writer.endElement("span");
            }
        }
    }

    private class DataTableHiddenEncodeStrategy
    implements EncodeStrategy {
        private DataTableHiddenEncodeStrategy() {
        }

        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            UIDataTable dataTable = (UIDataTable)component;
            writer.startElement("tbody", (UIComponent)dataTable);
            writer.writeAttribute("id", (Object)(dataTable.getClientId(context) + ":sc"), null);
            writer.writeAttribute("style", (Object)"display: none", null);
            writer.startElement("tr", (UIComponent)dataTable);
            writer.startElement("td", (UIComponent)dataTable);
        }

        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
        }
    }
}

