/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class UIExtendedDataTable
extends UIDataTableBase
implements MetaComponentResolver,
MetaComponentEncoder {
    public static final String SCROLL = "scroll";
    public static final String SUBMITTED_CLIENT_FIRST = "submittedClientFirst";
    public static final String OLD_CLIENT_FIRST = "oldClientFirst";
    private static final Logger RENDERKIT_LOG = RichfacesLogger.RENDERKIT.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SCROLL.equals(metaComponentId)) {
            Object oldRowKey = this.getRowKey();
            try {
                this.setRowKey(facesContext, null);
                String string = this.getClientId(facesContext) + '@' + metaComponentId;
                return string;
            }
            finally {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                }
                catch (Exception e) {
                    RENDERKIT_LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.resolveClientId(facesContext, contextComponent, metaComponentId);
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        Map attributes;
        Integer submittedClientFirst;
        if (SCROLL.equals(metaComponentId) && (submittedClientFirst = (Integer)(attributes = this.getAttributes()).remove(SUBMITTED_CLIENT_FIRST)) != null) {
            attributes.put(OLD_CLIENT_FIRST, this.getClientFirst());
            this.setClientFirst(submittedClientFirst);
        }
        super.encodeMetaComponent(context, metaComponentId);
    }

    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && visitRows && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            this.setRowKey(visitContext.getFacesContext(), null);
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, SCROLL);
            if (result != VisitResult.ACCEPT && result == VisitResult.COMPLETE) {
                return true;
            }
        }
        return super.visitDataChildren(visitContext, callback, visitRows);
    }

    protected int getActualFirst() {
        return this.getFirst() + this.getClientFirst();
    }

    protected int getActualRows() {
        int rows = this.getClientRows();
        if (rows > 0) {
            int r = this.getRows();
            if (r > 0 && r < rows) {
                rows = r;
            }
        } else {
            rows = this.getRows();
        }
        return rows;
    }

    public int getClientFirst() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientFirst), (Object)0);
    }

    public void setClientFirst(int clientFirst) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientFirst), (Object)clientFirst);
        this.updateState();
    }

    public void setFirst(int first) {
        super.setFirst(first);
        this.setClientFirst(0);
    }

    public int getClientRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientRows), (Object)0);
    }

    public void setClientRows(int clientRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientRows), (Object)clientRows);
        this.updateState();
    }

    public void setValueBinding(String name, ValueBinding binding) {
        super.setValueBinding(name, binding);
        if ("clientRows".equals(name)) {
            this.updateState();
        }
    }

    public void setValueExpression(String name, ValueExpression binding) {
        super.setValueExpression(name, binding);
        if ("clientRows".equals(name)) {
            this.updateState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        clientFirst,
        clientRows;

    }
}

