/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderComponentEvent;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.richfaces.component.DataTableColumnsIterator;
import org.richfaces.component.DataTableDataIterator;
import org.richfaces.component.DataTableFixedChildrenIterator;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.Row;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UISequence;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.FilteringEvent;
import org.richfaces.event.FilteringListener;
import org.richfaces.event.SortingEvent;
import org.richfaces.event.SortingListener;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.Arrangeable;
import org.richfaces.model.ArrangeableModel;
import org.richfaces.model.ArrangeableState;
import org.richfaces.model.ArrangeableStateDefaultImpl;
import org.richfaces.model.FilterField;
import org.richfaces.model.SortField;
import org.richfaces.model.SortMode;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDataTableBase
extends UISequence
implements Row,
MetaComponentResolver,
MetaComponentEncoder {
    public static final String HEADER = "header";
    public static final String FOOTER = "footer";
    public static final String BODY = "body";
    private static final Logger RENDERKIT_LOG = RichfacesLogger.RENDERKIT.getLogger();
    private static final Set<String> SUPPORTED_META_COMPONENTS = new HashSet<String>();

    public Iterator<UIComponent> columns() {
        return new DataTableColumnsIterator((UIComponent)this);
    }

    protected Iterator<UIComponent> fixedChildren() {
        return new DataTableFixedChildrenIterator(this);
    }

    protected Iterator<UIComponent> dataChildren() {
        return new DataTableDataIterator(this);
    }

    public UIComponent getHeader() {
        return this.getFacet(HEADER);
    }

    public UIComponent getFooter() {
        return this.getFacet(FOOTER);
    }

    public UIComponent getNoData() {
        return this.getFacet("noData");
    }

    public String getNoDataLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.noDataLabel));
    }

    public void setNoDataLabel(String noDataLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.noDataLabel), (Object)noDataLabel);
    }

    public boolean isColumnFacetPresent(String facetName) {
        Iterator<UIComponent> columns = this.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            if (!(component instanceof javax.faces.component.UIColumn) || !component.isRendered()) continue;
            UIComponent facet = component.getFacet(facetName);
            result = facet != null && facet.isRendered();
        }
        return result;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected ExtendedDataModel<?> createExtendedDataModel() {
        ExtendedDataModel dataModel = super.createExtendedDataModel();
        Arrangeable arrangeable = null;
        FacesContext context = this.getFacesContext();
        ArrangeableState state = this.createArrangeableState(context);
        if (dataModel instanceof Arrangeable) {
            arrangeable = (Arrangeable)dataModel;
        } else if (state != null) {
            ArrangeableModel arrangebleModel = new ArrangeableModel(dataModel, this.getVar(), this.getFilterVar());
            dataModel = arrangebleModel;
            arrangeable = arrangebleModel;
        }
        if (arrangeable != null) {
            arrangeable.arrange(context, state);
        }
        return dataModel;
    }

    private ArrangeableState createArrangeableState(FacesContext context) {
        SortField sortField;
        ArrangeableStateDefaultImpl state = null;
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField> sortFieldsMap = new LinkedHashMap<String, SortField>();
        Iterator<UIComponent> iterator = this.columns();
        while (iterator.hasNext()) {
            UIComponent component = iterator.next();
            if (!(component instanceof UIColumn) || !component.isRendered()) continue;
            UIColumn column = (UIColumn)component;
            FilterField filterField = column.getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = column.getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<Object> sortFields = new LinkedList<Object>();
        Collection<?> sortPriority = this.getSortPriority();
        if (sortPriority != null) {
            for (Object object : sortPriority) {
                sortField = (SortField)sortFieldsMap.get(object);
                if (sortField == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(object);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        if (!filterFields.isEmpty() || !sortFields.isEmpty()) {
            state = new ArrangeableStateDefaultImpl(filterFields, sortFields, context.getViewRoot().getLocale());
        }
        return state;
    }

    public void walk(FacesContext faces, DataVisitor visitor, Range range, Object argument) {
        Object key = this.getRowKey();
        this.captureOrigValue(faces);
        this.getExtendedDataModel().walk(faces, visitor, range, argument);
        this.setRowKey(faces, key);
        this.restoreOrigValue(faces);
    }

    public String getFilterVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterVar));
    }

    public void setFilterVar(String filterVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterVar), (Object)filterVar);
    }

    public Collection<Object> getSelection() {
        return (Collection)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection));
    }

    public void setSelection(Collection<Object> selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), selection);
    }

    public Collection<?> getSortPriority() {
        return (Collection)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortPriority));
    }

    public void setSortPriority(Collection<?> sortPriority) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortPriority), sortPriority);
    }

    public SortMode getSortMode() {
        return (SortMode)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortMode), (Object)SortMode.single);
    }

    public void setSortMode(SortMode sortMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortMode), (Object)sortMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SUPPORTED_META_COMPONENTS.contains(metaComponentId)) {
            Object oldRowKey = this.getRowKey();
            try {
                this.setRowKey(facesContext, null);
                String string = this.getClientId(facesContext) + '@' + metaComponentId;
                return string;
            }
            finally {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                }
                catch (Exception e) {
                    RENDERKIT_LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, (Object)this);
        MetaComponentRenderer renderer = (MetaComponentRenderer)this.getRenderer(context);
        renderer.encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    protected boolean visitFixedChildren(VisitContext visitContext, VisitCallback callback) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            VisitResult visitResult = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, HEADER);
            if (visitResult != VisitResult.ACCEPT && visitResult == VisitResult.COMPLETE) {
                return true;
            }
            visitResult = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, FOOTER);
            if (visitResult != VisitResult.ACCEPT && visitResult == VisitResult.COMPLETE) {
                return true;
            }
            if (visitResult == VisitResult.REJECT) {
                return false;
            }
        }
        return super.visitFixedChildren(visitContext, callback);
    }

    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && visitRows && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            this.setRowKey(visitContext.getFacesContext(), null);
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, BODY);
            if (result != VisitResult.ACCEPT) {
                return result == VisitResult.COMPLETE;
            }
        }
        return super.visitDataChildren(visitContext, callback, visitRows);
    }

    public void addSortingListener(SortingListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeSortingListener(SortingListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void addFilteringListener(FilteringListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeFilteringListener(FilteringListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public FilteringListener[] getFilteringListeners() {
        return (FilteringListener[])this.getFacesListeners(FilteringListener.class);
    }

    public SortingListener[] getSortingListeners() {
        return (SortingListener[])this.getFacesListeners(SortingListener.class);
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SortingEvent) {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
        if (event instanceof FilteringEvent) {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
        super.queueEvent(event);
    }

    public static Set<String> getSupportedMetaComponents() {
        return SUPPORTED_META_COMPONENTS;
    }

    static {
        SUPPORTED_META_COMPONENTS.add(HEADER);
        SUPPORTED_META_COMPONENTS.add(FOOTER);
        SUPPORTED_META_COMPONENTS.add(BODY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        filterVar,
        sortPriority,
        sortMode,
        first,
        rows,
        noDataLabel,
        selection;

    }
}

